/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.mixin.race;

import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import io.github.Memoires.trmysticism.registry.dimensions.ElementalRealmTeleporter;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import io.github.Memoires.trmysticism.util.UltimateUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.ITeleporter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RaceHelper.class})
public abstract class MixinRaceHelper {
    @Inject(method={"awakening"}, at={@At(value="HEAD")}, remap=false)
    private static void injectAwakening(Player player, boolean isHero, CallbackInfo ci) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        UltimateUtils.handleSkillUpgradeOnAwakening(player, storage);
    }

    @Inject(method={"handleRespawnDimension"}, at={@At(value="HEAD")}, remap=false)
    private static void injectRespawnDimension(Player player, Race race, CallbackInfo ci) {
        if (player instanceof ServerPlayer) {
            ServerLevel serverLevel;
            ResourceKey currentDimension;
            ResourceKey respawnDimension;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ResourceKey dimension = race.getRespawnDimension();
            if (dimension != (respawnDimension = serverPlayer.m_8963_()) && dimension != (currentDimension = player.m_9236_().m_46472_()) && (serverLevel = player.m_9236_().m_7654_().m_129880_(dimension)) != null && dimension == MysticismDimensions.ELEMENTAL_REALM) {
                player.changeDimension(serverLevel, (ITeleporter)new ElementalRealmTeleporter(true));
            }
        }
    }
}

