/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.network;

import com.google.common.base.Function;
import io.github.Memoires.trmysticism.network.play2client.AddContractRequestPacket;
import io.github.Memoires.trmysticism.network.play2client.ClientboundWeaponStorageOpenPacket;
import io.github.Memoires.trmysticism.network.play2client.ClientboundWeaponStorageUltOpenPacket;
import io.github.Memoires.trmysticism.network.play2client.CloseContractGUIPacket;
import io.github.Memoires.trmysticism.network.play2client.DissolveActiveContractPacket;
import io.github.Memoires.trmysticism.network.play2client.DissolveContractPacket;
import io.github.Memoires.trmysticism.network.play2client.OpenContractGUIPacket;
import io.github.Memoires.trmysticism.network.play2client.SyncPlayerCapabilityPacket;
import io.github.Memoires.trmysticism.network.play2client.UpdateAcceptedContractPacket;
import io.github.Memoires.trmysticism.network.play2client.UpdateForceSummonPacket;
import io.github.Memoires.trmysticism.network.play2server.AcceptContractPacket;
import io.github.Memoires.trmysticism.network.play2server.BeelzebubSkillProvidePacket;
import io.github.Memoires.trmysticism.network.play2server.BeelzebubSkillRecievePacket;
import io.github.Memoires.trmysticism.network.play2server.IntrinsicSkillsRequestPacket;
import io.github.Memoires.trmysticism.network.play2server.ItemAttackPacket;
import io.github.Memoires.trmysticism.network.play2server.OizysAttackPacket;
import io.github.Memoires.trmysticism.network.play2server.RequestSkillTrueCopyPacket;
import io.github.Memoires.trmysticism.network.play2server.RequestSkillTruePastePacket;
import io.github.Memoires.trmysticism.network.play2server.SyncIdolModePacket;
import io.github.Memoires.trmysticism.network.play2server.SyncLieModePacket;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class MysticismNetwork {
    private static final String PROTOCOL_VERSION = ModList.get().getModFileById("trmysticism").versionString().replaceAll("\\.", "");
    private static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("trmysticism", "main_channel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    private static final AtomicInteger PACKET_ID = new AtomicInteger();

    public static void register() {
        MysticismNetwork.registerPacket(IntrinsicSkillsRequestPacket.class, IntrinsicSkillsRequestPacket::toBytes, IntrinsicSkillsRequestPacket::new, IntrinsicSkillsRequestPacket::handle);
        MysticismNetwork.registerPacket(AcceptContractPacket.class, AcceptContractPacket::toBytes, AcceptContractPacket::new, AcceptContractPacket::handle);
        MysticismNetwork.registerPacket(RequestSkillTrueCopyPacket.class, RequestSkillTrueCopyPacket::toBytes, RequestSkillTrueCopyPacket::new, RequestSkillTrueCopyPacket::handle);
        MysticismNetwork.registerPacket(RequestSkillTruePastePacket.class, RequestSkillTruePastePacket::toBytes, RequestSkillTruePastePacket::new, RequestSkillTruePastePacket::handle);
        MysticismNetwork.registerPacket(ItemAttackPacket.class, ItemAttackPacket::toBytes, ItemAttackPacket::new, ItemAttackPacket::handle);
        MysticismNetwork.registerPacket(SyncIdolModePacket.class, SyncIdolModePacket::toBytes, SyncIdolModePacket::new, SyncIdolModePacket::handle);
        MysticismNetwork.registerPacket(SyncLieModePacket.class, SyncLieModePacket::toBytes, SyncLieModePacket::new, SyncLieModePacket::handle);
        MysticismNetwork.registerPacket(OizysAttackPacket.class, OizysAttackPacket::toBytes, OizysAttackPacket::new, OizysAttackPacket::handle);
        MysticismNetwork.registerPacket(BeelzebubSkillProvidePacket.class, BeelzebubSkillProvidePacket::toBytes, BeelzebubSkillProvidePacket::new, BeelzebubSkillProvidePacket::handle);
        MysticismNetwork.registerPacket(BeelzebubSkillRecievePacket.class, BeelzebubSkillRecievePacket::toBytes, BeelzebubSkillRecievePacket::new, BeelzebubSkillRecievePacket::handle);
        MysticismNetwork.registerPacket(SyncPlayerCapabilityPacket.class, SyncPlayerCapabilityPacket::toBytes, SyncPlayerCapabilityPacket::new, SyncPlayerCapabilityPacket::handle);
        MysticismNetwork.registerPacket(OpenContractGUIPacket.class, OpenContractGUIPacket::toBytes, OpenContractGUIPacket::new, OpenContractGUIPacket::handle);
        MysticismNetwork.registerPacket(CloseContractGUIPacket.class, CloseContractGUIPacket::toBytes, CloseContractGUIPacket::new, CloseContractGUIPacket::handle);
        MysticismNetwork.registerPacket(UpdateForceSummonPacket.class, UpdateForceSummonPacket::toBytes, UpdateForceSummonPacket::new, UpdateForceSummonPacket::handle);
        MysticismNetwork.registerPacket(DissolveContractPacket.class, DissolveContractPacket::toBytes, DissolveContractPacket::new, DissolveContractPacket::handle);
        MysticismNetwork.registerPacket(UpdateAcceptedContractPacket.class, UpdateAcceptedContractPacket::toBytes, UpdateAcceptedContractPacket::new, UpdateAcceptedContractPacket::handle);
        MysticismNetwork.registerPacket(AddContractRequestPacket.class, AddContractRequestPacket::toBytes, AddContractRequestPacket::new, AddContractRequestPacket::handle);
        MysticismNetwork.registerPacket(DissolveActiveContractPacket.class, DissolveActiveContractPacket::toBytes, DissolveActiveContractPacket::new, DissolveActiveContractPacket::handle);
        MysticismNetwork.registerPacket(ClientboundWeaponStorageOpenPacket.class, ClientboundWeaponStorageOpenPacket::toBytes, ClientboundWeaponStorageOpenPacket::new, ClientboundWeaponStorageOpenPacket::handle);
        MysticismNetwork.registerPacket(ClientboundWeaponStorageUltOpenPacket.class, ClientboundWeaponStorageUltOpenPacket::toBytes, ClientboundWeaponStorageUltOpenPacket::new, ClientboundWeaponStorageUltOpenPacket::handle);
    }

    private static <MSG> void registerPacket(Class<MSG> messageType, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(PACKET_ID.getAndIncrement(), messageType, encoder, decoder, messageConsumer);
    }

    public static <MSG> void sendToServer(MSG msg) {
        INSTANCE.sendToServer(msg);
    }

    public static <MSG> void sendTo(MSG msg, LivingEntity target) {
        if (!(target instanceof Player)) {
            return;
        }
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)target), msg);
    }

    public static <MSG> void sendToAllTrackingAndSelf(MSG msg, LivingEntity tracked) {
        INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> tracked), msg);
    }
}

