/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.network.play2client;

import io.github.Memoires.trmysticism.api.Contract;
import io.github.Memoires.trmysticism.client.screen.ContractScreen;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class CloseContractGUIPacket {
    private final int contractId;

    public CloseContractGUIPacket(Contract contract) {
        this.contractId = contract.getId();
    }

    public CloseContractGUIPacket(FriendlyByteBuf buf) {
        this.contractId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.contractId);
    }

    public static void handle(CloseContractGUIPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void handle(CloseContractGUIPacket message) {
            ContractScreen contractScreen;
            Minecraft mc = Minecraft.m_91087_();
            Screen screen = mc.f_91080_;
            if (screen instanceof ContractScreen && (contractScreen = (ContractScreen)screen).getContract().getId() == message.contractId) {
                mc.m_91152_(null);
                mc.f_91067_.m_91601_();
            }
        }
    }
}

