/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.network.play2client;

import io.github.Memoires.trmysticism.api.Contract;
import io.github.Memoires.trmysticism.client.screen.ContractScreen;
import java.util.function.Supplier;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class OpenContractGUIPacket {
    private final CompoundTag contractTag;

    public OpenContractGUIPacket(Contract contract) {
        this.contractTag = contract.save();
    }

    public OpenContractGUIPacket(FriendlyByteBuf buf) {
        this.contractTag = buf.m_130260_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.contractTag);
    }

    public static void handle(OpenContractGUIPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void handle(OpenContractGUIPacket message) {
            Minecraft mc = Minecraft.m_91087_();
            Contract contract = Contract.load(message.contractTag);
            mc.m_91152_((Screen)new ContractScreen(GameNarrator.f_93310_, contract));
        }
    }
}

