/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.network.play2server;

import io.github.Memoires.trmysticism.api.Contract;
import io.github.Memoires.trmysticism.capability.race.IMysticismPlayerCapability;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class AcceptContractPacket {
    private final int contractId;

    public AcceptContractPacket(Contract contract) {
        this.contractId = contract.getId();
    }

    public AcceptContractPacket(FriendlyByteBuf buf) {
        this.contractId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.contractId);
    }

    public static void handle(AcceptContractPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                MysticismPlayerCapability.getFrom((Player)player).ifPresent(arg_0 -> AcceptContractPacket.lambda$handle$0(message, (Player)player, arg_0));
            });
        }
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(AcceptContractPacket message, Player player, IMysticismPlayerCapability cap) {
        ArrayList<Contract> contractRequests = new ArrayList<Contract>(cap.getPendingContracts());
        for (Contract contract : contractRequests) {
            if (contract.getId() != message.contractId) continue;
            if (cap.acceptContract(contract)) {
                ServerPlayer contractor = player.m_20194_().m_6846_().m_11259_(contract.getContractorUUID());
                contractor.m_5661_((Component)Component.m_237110_((String)"trmysticism.message.contract.request_accept_contractor", (Object[])new Object[]{player.m_5446_()}).m_130940_(ChatFormatting.GREEN), false);
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.message.contract.request_accept_contractee", (Object[])new Object[]{contractor.m_5446_()}).m_130940_(ChatFormatting.GREEN), false);
                break;
            }
            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.message.contract.request_accept_fail").m_130940_(ChatFormatting.RED), false);
            break;
        }
    }
}

