/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.network.play2server;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import io.github.Memoires.trmysticism.ability.skill.ultimate.BeelzebubSkill;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class BeelzebubSkillProvidePacket {
    private final ResourceLocation skill;
    private final UUID targetUUID;

    public BeelzebubSkillProvidePacket(FriendlyByteBuf buf) {
        this.skill = buf.m_130281_();
        this.targetUUID = buf.m_130259_();
    }

    public BeelzebubSkillProvidePacket(ResourceLocation skill, UUID targetUUID) {
        this.skill = skill;
        this.targetUUID = targetUUID;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.skill);
        buf.m_130077_(this.targetUUID);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_9236_();
            Entity entity = (Entity)level.m_142646_().m_142694_(this.targetUUID);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity target = (LivingEntity)entity;
            this.createSkill(player, target);
        });
        ctx.get().setPacketHandled(true);
    }

    private void createSkill(ServerPlayer player, LivingEntity target) {
        ManasSkillInstance beelzeR;
        SkillStorage playerStorage = SkillAPI.getSkillsFrom((Entity)player);
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)target);
        Optional optionalBeelze = playerStorage.getSkill((ManasSkill)UltimateSkills.BEELZEBUB.get());
        if (!optionalBeelze.isEmpty() && !(beelzeR = (ManasSkillInstance)optionalBeelze.get()).onCoolDown()) {
            ManasSkill manasSkill;
            ManasSkillInstance instance;
            Optional createdInstance;
            ManasSkill oldSkill;
            ((BeelzebubSkill)((Object)UltimateSkills.BEELZEBUB.get())).addMasteryPoint(beelzeR, (LivingEntity)player, 5 + SkillUtils.getBonusMasteryPoint((ManasSkillInstance)beelzeR, (LivingEntity)player, (int)5));
            beelzeR.setCoolDown(10);
            CompoundTag tag = beelzeR.getOrCreateTag();
            ResourceLocation createdLocation = new ResourceLocation(tag.m_128461_("created_skill"));
            if (createdLocation.equals((Object)this.skill) && (oldSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(this.skill)) == null) {
                return;
            }
            ManasSkill createdSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(createdLocation);
            if (createdSkill != null && (createdInstance = playerStorage.getSkill(createdSkill)).isPresent() && (instance = (ManasSkillInstance)createdInstance.get()).isTemporarySkill()) {
                instance.getSkill();
            }
            if ((manasSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(this.skill)) != null) {
                tag.m_128359_("created_skill", String.valueOf(manasSkill.getRegistryName()));
                TensuraSkillInstance skillInstance = new TensuraSkillInstance(manasSkill);
                skillInstance.setRemoveTime(-2);
                skillInstance.setToggled(true);
                skillInstance.getOrCreateTag().m_128379_("BeelzePSkill", true);
                if (storage.learnSkill((ManasSkillInstance)skillInstance)) {
                    Player targetPlayer;
                    if (target instanceof Player) {
                        targetPlayer = (Player)target;
                        targetPlayer.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.hidden_ruler.paste.success", (Object[])new Object[]{manasSkill.getName(), target.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                    player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (target instanceof Player) {
                        targetPlayer = (Player)target;
                        TensuraSkillCapability.getFrom((Player)targetPlayer).ifPresent(cap -> {
                            if (cap.getSkillInSlot(0) == null) {
                                cap.setInstanceInSlot((ManasSkillInstance)skillInstance, 0);
                            } else if (cap.getSkillInSlot(1) == null) {
                                cap.setInstanceInSlot((ManasSkillInstance)skillInstance, 1);
                            } else if (cap.getSkillInSlot(2) == null) {
                                cap.setInstanceInSlot((ManasSkillInstance)skillInstance, 2);
                            }
                            TensuraSkillCapability.sync((Player)targetPlayer);
                        });
                    }
                }
                beelzeR.markDirty();
                storage.syncChanges();
                player.m_6915_();
            }
        }
    }
}

