/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.network.play2server;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class BeelzebubSkillRecievePacket {
    private final ResourceLocation skill;
    private final UUID targetUUID;

    public BeelzebubSkillRecievePacket(FriendlyByteBuf buf) {
        this.skill = buf.m_130281_();
        this.targetUUID = buf.m_130259_();
    }

    public BeelzebubSkillRecievePacket(ResourceLocation skill, UUID targetUUID) {
        this.skill = skill;
        this.targetUUID = targetUUID;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.skill);
        buf.m_130077_(this.targetUUID);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ServerLevel serverLevel = player.m_9236_();
            Entity entity = serverLevel.m_8791_(this.targetUUID);
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity target = (LivingEntity)entity;
            this.plunderSkill(player, target);
        });
        ctx.get().setPacketHandled(true);
    }

    private void plunderSkill(ServerPlayer player, LivingEntity target) {
        ManasSkill skill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(this.skill);
        if (skill == null) {
            return;
        }
        SkillStorage playerStorage = SkillAPI.getSkillsFrom((Entity)player);
        if (playerStorage.getSkill(skill).isPresent()) {
            return;
        }
        TensuraSkillInstance skillInstance = new TensuraSkillInstance(skill);
        skillInstance.getOrCreateTag().m_128379_("BeelzeRSkill", true);
        skillInstance.setToggled(true);
        if (playerStorage.learnSkill((ManasSkillInstance)skillInstance)) {
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_130940_(ChatFormatting.GREEN), false);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraSkillCapability.getFrom((Player)player).ifPresent(cap -> {
                if (cap.getSkillInSlot(0) == null) {
                    cap.setInstanceInSlot((ManasSkillInstance)skillInstance, 0);
                } else if (cap.getSkillInSlot(1) == null) {
                    cap.setInstanceInSlot((ManasSkillInstance)skillInstance, 1);
                } else if (cap.getSkillInSlot(2) == null) {
                    cap.setInstanceInSlot((ManasSkillInstance)skillInstance, 2);
                }
                TensuraSkillCapability.sync((Player)player);
            });
            playerStorage.syncChanges();
            SkillAPI.getSkillsFrom((Entity)player).syncChanges();
            player.m_6915_();
        }
    }
}

