/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.network.play2server;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class IntrinsicSkillsRequestPacket {
    private final String elementName;

    public IntrinsicSkillsRequestPacket(FriendlyByteBuf buf) {
        this.elementName = buf.m_130136_(Short.MAX_VALUE);
    }

    public IntrinsicSkillsRequestPacket(String elementName) {
        this.elementName = elementName;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.elementName);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer != null) {
                System.out.println("Server received packet from: " + serverPlayer.m_7755_().getString());
                System.out.println("Element: " + this.elementName);
                MysticismPlayerCapability.getFrom((Player)serverPlayer).ifPresent(capability -> {
                    System.out.println("Updating MysticismPlayerCapability for element: " + this.elementName);
                    ArrayList<TensuraSkill> skillList = new ArrayList<TensuraSkill>();
                    MagicElemental element = MagicElemental.valueOf((String)this.elementName.toUpperCase());
                    IntrinsicSkillsRequestPacket.assignElementAndSkills((Player)serverPlayer, skillList, element);
                    SkillStorage storage = SkillAPI.getSkillsFrom((Entity)serverPlayer);
                    for (TensuraSkill skill : skillList) {
                        storage.learnSkill((ManasSkill)skill);
                        serverPlayer.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    }
                    TensuraSkillCapability.sync((Player)serverPlayer);
                    MysticismPlayerCapability.sync((Player)serverPlayer);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void assignElementAndSkills(Player player, List<TensuraSkill> list, MagicElemental element) {
        switch (element) {
            case DARKNESS: {
                list.add((TensuraSkill)ExtraSkills.DARKNESS_MANIPULATION.get());
                list.add((TensuraSkill)ResistanceSkills.DARKNESS_ATTACK_RESISTANCE.get());
                SkillUtils.learnSkill((LivingEntity)player, (ManasSkill)((ManasSkill)ResistanceSkills.DARKNESS_ATTACK_RESISTANCE.get()));
                list.add((TensuraSkill)SpiritualMagics.DARKNESS.get());
                break;
            }
            case EARTH: {
                list.add((TensuraSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.EARTH_MANIPULATION.get());
                list.add((TensuraSkill)ResistanceSkills.EARTH_ATTACK_RESISTANCE.get());
                SkillUtils.learnSkill((LivingEntity)player, (ManasSkill)((ManasSkill)ResistanceSkills.EARTH_ATTACK_RESISTANCE.get()));
                list.add((TensuraSkill)SpiritualMagics.EARTH.get());
                break;
            }
            case FLAME: {
                list.add((TensuraSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.FLAME_MANIPULATION.get());
                list.add((TensuraSkill)ResistanceSkills.FLAME_ATTACK_RESISTANCE.get());
                SkillUtils.learnSkill((LivingEntity)player, (ManasSkill)((ManasSkill)ResistanceSkills.FLAME_ATTACK_RESISTANCE.get()));
                list.add((TensuraSkill)SpiritualMagics.FIRE.get());
                break;
            }
            case LIGHT: {
                list.add((TensuraSkill)ExtraSkills.LIGHT_MANIPULATION.get());
                list.add((TensuraSkill)ResistanceSkills.LIGHT_ATTACK_RESISTANCE.get());
                SkillUtils.learnSkill((LivingEntity)player, (ManasSkill)((ManasSkill)ResistanceSkills.LIGHT_ATTACK_RESISTANCE.get()));
                list.add((TensuraSkill)SpiritualMagics.LIGHT.get());
                break;
            }
            case SPACE: {
                list.add((TensuraSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.SPATIAL_MANIPULATION.get());
                list.add((TensuraSkill)ResistanceSkills.SPATIAL_ATTACK_RESISTANCE.get());
                SkillUtils.learnSkill((LivingEntity)player, (ManasSkill)((ManasSkill)ResistanceSkills.SPATIAL_ATTACK_RESISTANCE.get()));
                list.add((TensuraSkill)SpiritualMagics.SPACE.get());
                break;
            }
            case WATER: {
                list.add((TensuraSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.WATER_MANIPULATION.get());
                list.add((TensuraSkill)ResistanceSkills.WATER_ATTACK_RESISTANCE.get());
                SkillUtils.learnSkill((LivingEntity)player, (ManasSkill)((ManasSkill)ResistanceSkills.WATER_ATTACK_RESISTANCE.get()));
                list.add((TensuraSkill)SpiritualMagics.WATER.get());
                break;
            }
            case WIND: {
                list.add((TensuraSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.WIND_MANIPULATION.get());
                list.add((TensuraSkill)ResistanceSkills.WIND_ATTACK_RESISTANCE.get());
                SkillUtils.learnSkill((LivingEntity)player, (ManasSkill)((ManasSkill)ResistanceSkills.WIND_ATTACK_RESISTANCE.get()));
                list.add((TensuraSkill)SpiritualMagics.WIND.get());
            }
        }
        MysticismPlayerCapability.setElement(player, element);
        player.m_5661_((Component)Component.m_237115_((String)("trmysticism.spirit." + element.getNamespace())).m_130940_(element.getChatFormatting()), false);
    }
}

