/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.network.play2server;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import io.github.Memoires.trmysticism.ability.skill.ultimate.VicielSkill;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class RequestSkillTrueCopyPacket {
    private final ResourceLocation skill;

    public RequestSkillTrueCopyPacket(FriendlyByteBuf buf) {
        this.skill = buf.m_130281_();
    }

    public RequestSkillTrueCopyPacket(ResourceLocation skill) {
        this.skill = skill;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.skill);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                this.createSkill(player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void createSkill(ServerPlayer player) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional optionalVic = storage.getSkill((ManasSkill)UltimateSkills.VICIEL.get());
        if (optionalVic.isEmpty() || ((ManasSkillInstance)optionalVic.get()).onCoolDown()) {
            return;
        }
        ManasSkillInstance vic = (ManasSkillInstance)optionalVic.get();
        CompoundTag tag = vic.getOrCreateTag();
        ManasSkill newSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(this.skill);
        Optional<ManasSkillInstance> optionalSkillInstance = storage.getLearnedSkills().stream().filter(skillInstance -> skillInstance.getSkill().equals((Object)newSkill)).findFirst();
        if (newSkill == null) {
            return;
        }
        boolean alreadyHas = storage.getLearnedSkills().stream().filter(skillInstance -> skillInstance.getSkill().equals((Object)newSkill)).findFirst().map(skillInstance -> {
            if (skillInstance.getMastery() < 0) {
                return false;
            }
            CompoundTag tag1 = skillInstance.getOrCreateTag();
            if (tag1.m_128441_("alreadyHas")) {
                return tag1.m_128471_("alreadyHas");
            }
            return true;
        }).orElse(false);
        boolean notLearned = storage.getLearnedSkills().stream().filter(skillInstance -> skillInstance.getSkill().equals((Object)newSkill)).findFirst().map(skillInstance -> {
            Skill skill;
            ManasSkill patt4251$temp = skillInstance.getSkill();
            if (patt4251$temp instanceof Skill && (skill = (Skill)patt4251$temp).getType() == Skill.SkillType.RESISTANCE) {
                return false;
            }
            if (skillInstance.getMastery() > 0) {
                return true;
            }
            CompoundTag tag1 = skillInstance.getOrCreateTag();
            if (tag1.m_128441_("notLearned")) {
                return tag1.m_128471_("notLearned");
            }
            return true;
        }).orElse(false);
        int existingMastery = storage.getLearnedSkills().stream().filter(skillInstance -> skillInstance.getSkill().equals((Object)newSkill)).map(ManasSkillInstance::getMastery).findFirst().orElse(0);
        CompoundTag skillTags = optionalSkillInstance.map(ManasSkillInstance::getOrCreateTag).orElse(new CompoundTag());
        ArrayList tagKeys = new ArrayList(skillTags.m_128431_());
        HashMap<String, Object> tagKeyValuePairs = new HashMap<String, Object>();
        for (String key : tagKeys) {
            Tag tagValue = skillTags.m_128423_(key);
            if (tagValue instanceof StringTag) {
                tagKeyValuePairs.put(key, ((StringTag)tagValue).m_7916_());
                continue;
            }
            if (tagValue instanceof LongTag) {
                tagKeyValuePairs.put(key, ((LongTag)tagValue).m_7046_());
                continue;
            }
            if (tagValue instanceof IntTag) {
                tagKeyValuePairs.put(key, ((IntTag)tagValue).m_7047_());
                continue;
            }
            if (tagValue instanceof DoubleTag) {
                tagKeyValuePairs.put(key, ((DoubleTag)tagValue).m_7061_());
                continue;
            }
            if (!(tagValue instanceof ListTag)) continue;
            ListTag listTag = (ListTag)tagValue;
            ArrayList<Tag> elements = new ArrayList<Tag>();
            for (Tag element : listTag) {
                elements.add(element);
            }
            tagKeyValuePairs.put(key, elements);
        }
        System.out.println("Existing Mastery: " + existingMastery);
        System.out.println("Skill Tag Keys and Values: " + tagKeyValuePairs);
        List copiedSkills = storage.getLearnedSkills().stream().filter(skillInstance -> skillInstance.getOrCreateTag().m_128471_("vicSkill")).peek(skillInstance -> {
            CompoundTag skillTag = skillInstance.getOrCreateTag();
            if (!skillTag.m_128441_("timeAdded")) {
                skillTag.m_128356_("timeAdded", System.currentTimeMillis());
            }
        }).collect(Collectors.toList());
        if (copiedSkills.size() >= 5) {
            ManasSkillInstance oldestSkill = copiedSkills.stream().min(Comparator.comparingLong(skill -> skill.getOrCreateTag().m_128454_("timeAdded"))).orElse(null);
            if (oldestSkill != null && !oldestSkill.getTag().m_128471_("alreadyHas")) {
                storage.forgetSkill(oldestSkill.getSkill());
            } else if (oldestSkill.getTag().m_128471_("notLearned")) {
                int learningPoints = oldestSkill.getTag().m_128451_("learningPoint");
                oldestSkill.setMastery(learningPoints);
                oldestSkill.getTag().m_128379_("vicSkill", false);
            } else {
                CompoundTag oldSkillTag = oldestSkill.getOrCreateTag();
                oldSkillTag.m_128379_("vicSkill", false);
            }
        }
        double skillCost = newSkill instanceof Skill ? ((Skill)newSkill).getObtainingEpCost() : 0.0;
        boolean finalAlreadyHas = alreadyHas;
        boolean finalNotLearned = notLearned;
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
            Skill skill;
            double currentMP = cap.getBaseMagicule();
            if (currentMP < skillCost) {
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.lack_magicule").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                return;
            }
            TensuraPlayerCapability.decreaseMagicule((Player)player, (double)skillCost);
            tag.m_128359_("copied_skill", String.valueOf(newSkill.getRegistryName()));
            tag.m_128356_("timeAdded", System.currentTimeMillis());
            TensuraSkillInstance skillInstance = new TensuraSkillInstance(newSkill);
            skillInstance.setMastery(existingMastery);
            CompoundTag newSkillTag = skillInstance.getOrCreateTag();
            for (Map.Entry entry : tagKeyValuePairs.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String) {
                    newSkillTag.m_128359_(key, (String)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    newSkillTag.m_128379_(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Long) {
                    newSkillTag.m_128356_(key, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Integer) {
                    newSkillTag.m_128405_(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    newSkillTag.m_128347_(key, ((Double)value).doubleValue());
                    continue;
                }
                if (!(value instanceof List)) continue;
                List list = (List)value;
                ListTag newListTag = new ListTag();
                for (Tag listItem : list) {
                    newListTag.add((Object)listItem);
                }
                newSkillTag.m_128365_(key, (Tag)newListTag);
            }
            newSkillTag.m_128379_("vicSkill", true);
            newSkillTag.m_128356_("timeAdded", System.currentTimeMillis());
            newSkillTag.m_128379_("alreadyHas", finalAlreadyHas);
            newSkillTag.m_128379_("notLearned", finalNotLearned);
            newSkillTag.m_128379_("NoMagiculeCost", true);
            ManasSkill patt11024$temp = skillInstance.getSkill();
            if (patt11024$temp instanceof Skill && (skill = (Skill)patt11024$temp).getType() == Skill.SkillType.RESISTANCE && skillInstance.getMastery() < 0) {
                newSkillTag.m_128379_("resSkill", true);
                newSkillTag.m_128405_("resMastery", existingMastery);
            }
            if (newSkillTag.m_128471_("notLearned")) {
                newSkillTag.m_128405_("learningPoint", existingMastery);
            }
            System.out.println("Setting tags for copied skill: " + newSkill.getRegistryName());
            System.out.println("vicSkill: " + newSkillTag.m_128471_("vicSkill"));
            System.out.println("timeAdded: " + newSkillTag.m_128454_("timeAdded"));
            System.out.println("alreadyHas: " + newSkillTag.m_128471_("alreadyHas"));
            System.out.println("notLearned: " + newSkillTag.m_128471_("alreadyHas"));
            System.out.println("finalNotLearned: " + finalNotLearned);
            System.out.println("finalAlreadyHas: " + finalAlreadyHas);
            ((VicielSkill)((Object)((Object)UltimateSkills.VICIEL.get()))).addMasteryPoint(vic, (LivingEntity)player, 5 + SkillUtils.getBonusMasteryPoint((ManasSkillInstance)vic, (LivingEntity)player, (int)5));
            if (finalNotLearned) {
                skillInstance.setMastery(1);
                storage.updateSkill((ManasSkillInstance)skillInstance);
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{newSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraSkillCapability.getFrom((Player)player).ifPresent(skillCap -> {
                    if (skillCap.getSkillInSlot(0) == null) {
                        skillCap.setInstanceInSlot((ManasSkillInstance)skillInstance, 0);
                    } else if (skillCap.getSkillInSlot(1) == null) {
                        skillCap.setInstanceInSlot((ManasSkillInstance)skillInstance, 1);
                    } else if (skillCap.getSkillInSlot(2) == null) {
                        skillCap.setInstanceInSlot((ManasSkillInstance)skillInstance, 2);
                    }
                    TensuraSkillCapability.sync((Player)player);
                });
            } else if (!finalAlreadyHas) {
                skillInstance.setRemoveTime(-2);
                if (storage.learnSkill((ManasSkillInstance)skillInstance)) {
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{newSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraSkillCapability.getFrom((Player)player).ifPresent(skillCap -> {
                        if (skillCap.getSkillInSlot(0) == null) {
                            skillCap.setInstanceInSlot((ManasSkillInstance)skillInstance, 0);
                        } else if (skillCap.getSkillInSlot(1) == null) {
                            skillCap.setInstanceInSlot((ManasSkillInstance)skillInstance, 1);
                        } else if (skillCap.getSkillInSlot(2) == null) {
                            skillCap.setInstanceInSlot((ManasSkillInstance)skillInstance, 2);
                        }
                        TensuraSkillCapability.sync((Player)player);
                    });
                }
            } else {
                ManasSkill patt14677$temp = skillInstance.getSkill();
                if (patt14677$temp instanceof Skill && (skill = (Skill)patt14677$temp).getType() == Skill.SkillType.RESISTANCE) {
                    skillInstance.setMastery(1);
                }
                storage.updateSkill((ManasSkillInstance)skillInstance);
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.viciel.copy_bank", (Object[])new Object[]{newSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            skillInstance.setToggled(true);
            ManasSkill patt15441$temp = skillInstance.getSkill();
            if (patt15441$temp instanceof Skill) {
                skill = (Skill)patt15441$temp;
                if (skill.getType() == Skill.SkillType.UNIQUE) {
                    vic.setCoolDown(180);
                } else if (skill.getType() == Skill.SkillType.EXTRA) {
                    vic.setCoolDown(60);
                } else if (skill.getType() == Skill.SkillType.COMMON || skill.getType() == Skill.SkillType.INTRINSIC) {
                    vic.setCoolDown(10);
                }
            }
            vic.markDirty();
            storage.syncChanges();
            player.m_6915_();
        });
    }
}

