/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.network.play2server;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import io.github.Memoires.trmysticism.ability.skill.ultimate.VicielSkill;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class RequestSkillTruePastePacket {
    private final ResourceLocation skill;
    private final UUID targetUUID;

    public RequestSkillTruePastePacket(FriendlyByteBuf buf) {
        this.skill = buf.m_130281_();
        this.targetUUID = buf.m_130259_();
    }

    public RequestSkillTruePastePacket(ResourceLocation skill, UUID targetUUID) {
        this.skill = skill;
        this.targetUUID = targetUUID;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.skill);
        buf.m_130077_(this.targetUUID);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                LivingEntity targetEntity = (LivingEntity)player.m_9236_().m_8791_(this.targetUUID);
                this.pasteSkill(player, targetEntity);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private void pasteSkill(ServerPlayer player, LivingEntity target) {
        boolean notLearned;
        boolean alreadyHas;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        SkillStorage targetStorage = SkillAPI.getSkillsFrom((Entity)target);
        Optional optionalVic = storage.getSkill((ManasSkill)UltimateSkills.VICIEL.get());
        if (optionalVic.isEmpty() || ((ManasSkillInstance)optionalVic.get()).onCoolDown()) {
            return;
        }
        ManasSkillInstance vic = (ManasSkillInstance)optionalVic.get();
        CompoundTag tag = vic.getOrCreateTag();
        ResourceLocation createdLocation = new ResourceLocation(tag.m_128461_("copied_skill"));
        ManasSkill manasSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(this.skill);
        Optional targetOptionalSkill = targetStorage.getSkill(manasSkill);
        ManasSkillInstance targetOriginalSkillInstance = targetOptionalSkill.isPresent() ? (ManasSkillInstance)targetOptionalSkill.get() : null;
        Optional optionalSkill = storage.getSkill(manasSkill);
        if (optionalSkill.isEmpty()) {
            return;
        }
        ManasSkillInstance originalSkillInstance = (ManasSkillInstance)optionalSkill.get();
        int existingMastery = originalSkillInstance.getMastery();
        TensuraSkillInstance playerSkillInstance = new TensuraSkillInstance(manasSkill);
        CompoundTag newSkillTag = originalSkillInstance.getOrCreateTag();
        for (String key : newSkillTag.m_128431_()) {
            System.out.println("Skill Tag Key: " + key + ", Value: " + newSkillTag.m_128423_(key));
        }
        boolean resSkill = newSkillTag.m_128471_("resSkill");
        int resExistingMastery = newSkillTag.m_128451_("resMastery");
        int learningPoints = newSkillTag.m_128451_("learningPoint");
        if (newSkillTag.m_128471_("notLearned")) {
            originalSkillInstance.setMastery(learningPoints);
        }
        if (newSkillTag.m_128471_("resSkill")) {
            originalSkillInstance.setMastery(resExistingMastery);
        }
        if (SkillUtils.hasSkill((Entity)target, (ManasSkill)((ManasSkillInstance)optionalSkill.get()).getSkill())) {
            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.already_has").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return;
        }
        if (optionalSkill.isPresent()) {
            CompoundTag skillTag = originalSkillInstance.getOrCreateTag();
            alreadyHas = skillTag.m_128441_("alreadyHas") && skillTag.m_128471_("alreadyHas");
            boolean bl = notLearned = skillTag.m_128441_("notLearned") && skillTag.m_128471_("notLearned");
            if (notLearned) {
                skillTag.m_128473_("vicSkill");
                skillTag.m_128473_("timeAdded");
                skillTag.m_128473_("notLearned");
                skillTag.m_128473_("learningPoint");
            }
            if (alreadyHas) {
                skillTag.m_128473_("alreadyHas");
                skillTag.m_128473_("vicSkill");
                skillTag.m_128473_("timeAdded");
                skillTag.m_128473_("resSkill");
                skillTag.m_128473_("resMastery");
            }
        } else {
            existingMastery = 0;
            alreadyHas = false;
            notLearned = false;
        }
        ManasSkill createdSkill = (ManasSkill)SkillAPI.getSkillRegistry().getValue(createdLocation);
        if (manasSkill == null) {
            return;
        }
        double skillCost = manasSkill instanceof Skill ? ((Skill)manasSkill).getObtainingEpCost() : 0.0;
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
            Skill skill;
            double currentMP = cap.getMagicule();
            if (currentMP < skillCost) {
                player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.lack_magicule").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                return;
            }
            TensuraPlayerCapability.decreaseMagicule((Player)player, (double)skillCost);
            tag.m_128359_("copied_skill", String.valueOf(manasSkill.getRegistryName()));
            TensuraSkillInstance targetSkillInstance = new TensuraSkillInstance(manasSkill);
            targetSkillInstance.setMastery(0);
            targetSkillInstance.setRemoveTime(-2);
            CompoundTag resSkillTag = targetOriginalSkillInstance != null ? targetOriginalSkillInstance.getOrCreateTag() : new CompoundTag();
            targetSkillInstance.getOrCreateTag().m_128379_("vicSkill", true);
            ((VicielSkill)((Object)((Object)UltimateSkills.VICIEL.get()))).addMasteryPoint(vic, (LivingEntity)player, 5 + SkillUtils.getBonusMasteryPoint((ManasSkillInstance)vic, (LivingEntity)player, (int)5));
            ManasSkill patt7443$temp = targetSkillInstance.getSkill();
            if (patt7443$temp instanceof Skill) {
                skill = (Skill)patt7443$temp;
                if (skill.getType() == Skill.SkillType.RESISTANCE) {
                    if (targetOriginalSkillInstance != null && targetOriginalSkillInstance.getMastery() < 0) {
                        resSkillTag.m_128379_("resSkill", true);
                        resSkillTag.m_128405_("resMastery", targetOriginalSkillInstance.getMastery());
                        targetOriginalSkillInstance.setMastery(1);
                        if (target instanceof Player) {
                            targetPlayer = (Player)target;
                            targetPlayer.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                        }
                        player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.hidden_ruler.paste.success", (Object[])new Object[]{manasSkill.getName(), target.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                } else if (targetStorage.learnSkill((ManasSkillInstance)targetSkillInstance)) {
                    if (target instanceof Player) {
                        targetPlayer = (Player)target;
                        targetPlayer.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.hidden_ruler.paste.success", (Object[])new Object[]{manasSkill.getName(), target.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (target instanceof Player) {
                        targetPlayer = (Player)target;
                        TensuraSkillCapability.getFrom((Player)targetPlayer).ifPresent(skillCap -> {
                            if (skillCap.getSkillInSlot(0) == null) {
                                skillCap.setInstanceInSlot((ManasSkillInstance)targetSkillInstance, 0);
                            } else if (skillCap.getSkillInSlot(1) == null) {
                                skillCap.setInstanceInSlot((ManasSkillInstance)targetSkillInstance, 1);
                            } else if (skillCap.getSkillInSlot(2) == null) {
                                skillCap.setInstanceInSlot((ManasSkillInstance)targetSkillInstance, 2);
                            }
                            TensuraSkillCapability.sync((Player)targetPlayer);
                        });
                    }
                } else {
                    System.out.println("Failed to give skill to the target.");
                }
            } else {
                System.out.println("targetSkillInstance.getSkill() is not an instance of Skill.");
            }
            targetSkillInstance.setToggled(true);
            ManasSkill patt10699$temp = playerSkillInstance.getSkill();
            if (patt10699$temp instanceof Skill) {
                skill = (Skill)patt10699$temp;
                if (skill.getType() == Skill.SkillType.UNIQUE) {
                    vic.setCoolDown(30);
                } else if (skill.getType() == Skill.SkillType.EXTRA) {
                    vic.setCoolDown(10);
                } else if (skill.getType() == Skill.SkillType.COMMON || skill.getType() == Skill.SkillType.INTRINSIC) {
                    vic.setCoolDown(5);
                }
            }
            if (!alreadyHas && !notLearned) {
                storage.forgetSkill((ManasSkillInstance)playerSkillInstance);
            }
            vic.markDirty();
            targetStorage.syncChanges();
            storage.syncChanges();
            player.m_6915_();
        });
    }
}

