/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.network.play2server;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import io.github.Memoires.trmysticism.ability.skill.ultimate.AmeNoUzumeSkill;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class SyncIdolModePacket {
    private final boolean idolMode;
    private final UUID playerId;

    public SyncIdolModePacket(UUID playerId, boolean idolMode) {
        this.playerId = playerId;
        this.idolMode = idolMode;
    }

    public SyncIdolModePacket(FriendlyByteBuf buf) {
        this.playerId = buf.m_130259_();
        this.idolMode = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerId);
        buf.writeBoolean(this.idolMode);
    }

    public static void handle(SyncIdolModePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                Optional instanceOpt = storage.getSkill((ManasSkill)UltimateSkills.AME_NO_UZUME.get());
                instanceOpt.ifPresent(instance -> {
                    AmeNoUzumeSkill skill = (AmeNoUzumeSkill)instance.getSkill();
                    skill.setIdolModeClient(msg.idolMode);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

