/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.network.play2server;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import io.github.Memoires.trmysticism.ability.skill.unique.CaptivatorSkill;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SyncLieModePacket {
    private final boolean lieMode;
    private final UUID playerId;

    public SyncLieModePacket(UUID playerId, boolean lieMode) {
        this.playerId = playerId;
        this.lieMode = lieMode;
    }

    public SyncLieModePacket(FriendlyByteBuf buf) {
        this.playerId = buf.m_130259_();
        this.lieMode = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerId);
        buf.writeBoolean(this.lieMode);
    }

    public static void handle(SyncLieModePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player = Minecraft.m_91087_().f_91073_.m_46003_(msg.playerId);
            if (player != null) {
                SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                Optional instanceOpt = storage.getSkill((ManasSkill)UniqueSkills.CAPTIVATOR.get());
                instanceOpt.ifPresent(instance -> {
                    CaptivatorSkill skill = (CaptivatorSkill)instance.getSkill();
                    skill.setLieModeClient(msg.lieMode);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

