/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.daemonDoll;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.daemonDoll.ArchDollRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class DaemonDollRace
extends ArchDollRace {
    @Override
    public double getBaseHealth() {
        return 900.0;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 4.5;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    @Override
    public double getSprintSpeed() {
        return 1.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)125000.0, (Object)325000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)200000.0, (Object)525000.0);
    }

    @Override
    public boolean isSpiritual() {
        return true;
    }

    @Override
    public ResourceKey<Level> getRespawnDimension() {
        return Level.f_46428_;
    }

    @Override
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DAEMON_DOLL);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DEVIL_DOLL);
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return null;
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 50.0;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DEVIL_DOLL));
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.ARCH_DOLL));
        return list;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.name_requirement"));
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double percentage = 0.0;
        double percentageName = 0.0;
        if (TensuraEPCapability.getName((LivingEntity)player) != null) {
            percentageName += 50.0;
        }
        return percentageName + TensuraPlayerCapability.getBaseEP((Player)player) * 50.0 / (Double)MysticismConfig.INSTANCE.racesConfig.epToDaemonDoll.get();
    }

    @Override
    public void triggerEvolutionRewards(Player player) {
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
            if (this.getManaEvolutionReward() > 10.0) {
                cap.setBaseMagicule(cap.getBaseMagicule() + this.getManaEvolutionReward(), (LivingEntity)player);
            } else if (cap.getBaseMagicule() < this.getMinBaseMagicule()) {
                cap.setBaseMagicule(this.getMinBaseMagicule(), (LivingEntity)player);
            }
            if (this.getAuraEvolutionReward() > 10.0) {
                cap.setBaseAura(cap.getBaseAura() + this.getAuraEvolutionReward(), (LivingEntity)player);
            } else if (cap.getBaseAura() < this.getMinBaseAura()) {
                cap.setBaseAura(this.getMinBaseAura(), (LivingEntity)player);
            }
            ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
            list.add((TensuraSkill)IntrinsicSkills.POSSESSION.get());
            list.forEach(skill -> SkillAPI.getSkillsFrom((Entity)player).forgetSkill((ManasSkill)skill));
        });
        TensuraPlayerCapability.sync((Player)player);
    }
}

