/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.direwolf;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class DirewolfRace
extends Race {
    public DirewolfRace() {
        super(Race.Difficulty.EASY);
    }

    public boolean isMajin() {
        return true;
    }

    public double getBaseHealth() {
        return 30.0;
    }

    public double getBaseAttackDamage() {
        return 3.0;
    }

    public double getBaseAttackSpeed() {
        return 4.0;
    }

    public double getKnockbackResistance() {
        return 0.0;
    }

    public float getPlayerSize() {
        return 1.5f;
    }

    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)0.25);
    }

    public double getMovementSpeed() {
        return 0.1;
    }

    public double getSprintSpeed() {
        return 0.6;
    }

    public double getSpiritualHealthMultiplier() {
        return 2.0;
    }

    public double getAdditionalSpiritualHealth() {
        return 20.0;
    }

    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)1834.0, (Object)2166.0);
    }

    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)1833.0, (Object)2167.0);
    }

    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)CommonSkills.COERCION.get());
        list.add((TensuraSkill)CommonSkills.THOUGHT_COMMUNICATION.get());
        return list;
    }

    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.MAGIC_FANG);
    }

    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_WOLF);
    }

    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.MAGIC_FANG);
    }

    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        TensuraPlayerCapability.setTrackedRace((LivingEntity)player, null);
        Holder biomes = player.m_9236_().m_204166_(player.m_20097_());
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.MAGIC_FANG));
        if (!biomes.m_203656_(Tags.Biomes.IS_DRY_OVERWORLD) && !biomes.m_203656_(Tags.Biomes.IS_DRY_NETHER)) {
            if (!(biomes.m_203656_(BiomeTags.f_207603_) || biomes.m_203656_(BiomeTags.f_207604_) || biomes.m_203656_(Tags.Biomes.IS_SWAMP))) {
                if (!biomes.m_203656_(BiomeTags.f_207611_) && !biomes.m_203656_(BiomeTags.f_207610_)) {
                    if (!biomes.m_203656_(Tags.Biomes.IS_CAVE) && !biomes.m_203656_(Tags.Biomes.IS_SLOPE)) {
                        if (biomes.m_203656_(BiomeTags.f_215818_)) {
                            list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.PURPLE_FANG));
                        }
                    } else {
                        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.BROWN_FANG));
                    }
                } else {
                    list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREEN_FANG));
                }
            } else {
                list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.BLUE_FANG));
            }
        } else {
            list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.RED_FANG));
        }
        int lightLevel = player.m_9236_().m_46803_(player.m_20097_());
        int brightThreshold = 12;
        int darkThreshold = 8;
        if (lightLevel > brightThreshold) {
            list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.LIGHT_FANG));
        }
        if (lightLevel < darkThreshold) {
            list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DARK_FANG));
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        List<ResourceLocation> tempestWolf = List.of(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.firstSkillForTempestWolf.get()), new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.secondSkillForTempestWolf.get()), new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.thirdSkillForTempestWolf.get()));
        List<ResourceLocation> blazeWolf = List.of(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.firstSkillForBlazeWolf.get()), new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.secondSkillForBlazeWolf.get()), new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.thirdSkillForBlazeWolf.get()));
        List<ResourceLocation> frostfangWolf = List.of(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.firstSkillForFrostfangWolf.get()), new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.secondSkillForFrostfangWolf.get()), new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.thirdSkillForFrostfangWolf.get()));
        if (tempestWolf.stream().map(skillLocation -> (ManasSkill)SkillAPI.getSkillRegistry().getValue(skillLocation)).filter(Objects::nonNull).map(arg_0 -> ((SkillStorage)storage).getSkill(arg_0)).allMatch(Optional::isPresent) && biomes.m_203656_(Tags.Biomes.IS_PEAK)) {
            list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.TEMPEST_WOLF));
        }
        if (frostfangWolf.stream().map(skillLocation -> (ManasSkill)SkillAPI.getSkillRegistry().getValue(skillLocation)).filter(Objects::nonNull).map(arg_0 -> ((SkillStorage)storage).getSkill(arg_0)).allMatch(Optional::isPresent) && biomes.m_203656_(Tags.Biomes.IS_COLD)) {
            list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.FROSTFANG_WOLF));
        }
        if (blazeWolf.stream().map(skillLocation -> (ManasSkill)SkillAPI.getSkillRegistry().getValue(skillLocation)).filter(Objects::nonNull).map(arg_0 -> ((SkillStorage)storage).getSkill(arg_0)).allMatch(Optional::isPresent) && biomes.m_203656_(BiomeTags.f_207612_)) {
            list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.BLAZE_WOLF));
        }
        if (storage.getSkill((ManasSkill)ExtraSkills.SOUND_MANIPULATION.get()).isPresent()) {
            list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GUITAR_WOLF));
        }
        return list;
    }

    public void raceAbility(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (DirewolfRace.isInPlayerStack(serverPlayer)) {
            return;
        }
        LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)serverPlayer, (double)5.0, (boolean)false);
        if (!(target instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer targetSp = (ServerPlayer)target;
        if (targetSp == serverPlayer) {
            return;
        }
        if (DirewolfRace.chainContains(serverPlayer, targetSp)) {
            return;
        }
        int depth = DirewolfRace.playerStackDepth(serverPlayer);
        if (depth >= 2) {
            return;
        }
        if (targetSp.m_146895_() != null) {
            return;
        }
        ServerPlayer top = DirewolfRace.topMostServerPlayer(serverPlayer);
        if (top == null) {
            return;
        }
        if (targetSp.m_20159_()) {
            return;
        }
        targetSp.m_20329_((Entity)top);
    }

    private static boolean isInPlayerStack(ServerPlayer player) {
        if (player.m_20202_() instanceof ServerPlayer) {
            return true;
        }
        return player.m_146895_() instanceof ServerPlayer;
    }

    private static int playerStackDepth(ServerPlayer base) {
        Entity entity;
        int depth = 0;
        ServerPlayer cur = base;
        while ((entity = cur.m_146895_()) instanceof ServerPlayer) {
            ServerPlayer next = (ServerPlayer)entity;
            ++depth;
            cur = next;
        }
        return depth;
    }

    @Nullable
    private static ServerPlayer topMostServerPlayer(ServerPlayer base) {
        Entity entity;
        ServerPlayer cur = base;
        while ((entity = cur.m_146895_()) instanceof ServerPlayer) {
            ServerPlayer next;
            cur = next = (ServerPlayer)entity;
        }
        return cur;
    }

    private static boolean chainContains(ServerPlayer base, ServerPlayer target) {
        if (base == target) {
            return true;
        }
        ServerPlayer cur = base;
        while (cur.m_146895_() != null) {
            if (cur.m_146895_() == target) {
                return true;
            }
            cur = cur.m_146895_();
        }
        return false;
    }
}

