/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.direwolf.blaze;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.direwolf.blaze.BlazeWolfRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class StarBlazeWolfRace
extends BlazeWolfRace {
    @Override
    public double getBaseHealth() {
        return 600.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 9.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.3;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.4;
    }

    @Override
    public float getPlayerSize() {
        return 1.5f;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)1.0);
    }

    @Override
    public double getMovementSpeed() {
        return 0.17;
    }

    @Override
    public double getSprintSpeed() {
        return 1.2;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 4.0;
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 20.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)31334.0, (Object)33334.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)14667.0, (Object)16667.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_WOLF);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_WOLF);
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_WOLF));
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.BLAZE_WOLF));
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double baseEP = Math.min(TensuraPlayerCapability.getBaseEP((Player)player) * 50.0 / (Double)MysticismConfig.INSTANCE.racesConfig.epToStarBlazeWolf.get(), 50.0);
        double skillContribution1 = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.firstSkillForStarBlazeWolf.get()), (Integer)MysticismConfig.INSTANCE.racesConfig.masteryForFirstStarBlazeWolfSkill.get(), player);
        double skillContribution2 = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.secondSkillForStarBlazeWolf.get()), (Integer)MysticismConfig.INSTANCE.racesConfig.masteryForSecondStarBlazeWolfSkill.get(), player);
        double skillContribution3 = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.thirdSkillForStarBlazeWolf.get()), (Integer)MysticismConfig.INSTANCE.racesConfig.masteryForThirdStarBlazeWolfSkill.get(), player);
        return baseEP + skillContribution1 + skillContribution2 + skillContribution3;
    }

    private double calculateSkillContribution(ResourceLocation skillLocation, int masteryThreshold, Player player) {
        ManasSkillInstance instance;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional optionalSkill = storage.getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(skillLocation));
        if (optionalSkill.isPresent() && (instance = (ManasSkillInstance)optionalSkill.get()).getMastery() >= masteryThreshold) {
            return 16.68;
        }
        return 0.0;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        list.add((Component)Component.m_237115_((String)"trmysticism.flame_manipulation.mastery"));
        list.add((Component)Component.m_237115_((String)"trmysticism.wind_manipulation.mastery"));
        list.add((Component)Component.m_237115_((String)"trmysticism.earth_manipulation.mastery"));
        list.add((Component)Component.m_237115_((String)"trmysticism.configurable"));
        return list;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.GODWOLF_SENSE.get());
        list.add((TensuraSkill)ExtraSkills.PROFANED_PROMINENCE.get());
        return list;
    }
}

