/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.elemental;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.elemental.MediumSpiritRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class GreaterSpiritRace
extends MediumSpiritRace {
    @Override
    public double getBaseHealth() {
        return 400.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 7.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.6;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)1.0);
    }

    @Override
    public double getSprintSpeed() {
        return 1.2;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 6.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)10000.0, (Object)10000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)15000.0, (Object)15000.0);
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)ResistanceSkills.MAGIC_RESISTANCE.get());
        MagicElemental element = MysticismPlayerCapability.getElement(player);
        if (element == null) {
            return list;
        }
        switch (element) {
            case DARKNESS: {
                list.add((TensuraSkill)ExtraSkills.MAGIC_DARKNESS_TRANSFORM.get());
                break;
            }
            case EARTH: {
                list.add((TensuraSkill)ExtraSkills.MAGIC_EARTH_TRANSFORM.get());
                break;
            }
            case FLAME: {
                list.add((TensuraSkill)ExtraSkills.MAGIC_FLAME_TRANSFORM.get());
                break;
            }
            case LIGHT: {
                list.add((TensuraSkill)ExtraSkills.MAGIC_LIGHT_TRANSFORM.get());
                break;
            }
            case SPACE: {
                list.add((TensuraSkill)ExtraSkills.MAGIC_SPACE_TRANSFORM.get());
                break;
            }
            case WATER: {
                list.add((TensuraSkill)ExtraSkills.MAGIC_WATER_TRANSFORM.get());
                break;
            }
            case WIND: {
                list.add((TensuraSkill)ExtraSkills.MAGIC_WIND_TRANSFORM.get());
            }
        }
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SPIRIT_LORD);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SPIRIT_LORD);
    }

    @Override
    public Race getHarvestFestivalEvolution(@NotNull Player player) {
        return null;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SPIRIT_LORD));
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.MEDIUM_SPIRIT));
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        return TensuraPlayerCapability.getBaseEP((Player)player) * 100.0 / (Double)MysticismConfig.INSTANCE.racesConfig.epToGreaterSpirit.get();
    }
}

