/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.elemental;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.network.MysticismNetwork;
import io.github.Memoires.trmysticism.network.play2server.IntrinsicSkillsRequestPacket;
import io.github.Memoires.trmysticism.race.MysticismRace;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class LesserSpiritRace
extends MysticismRace {
    public LesserSpiritRace() {
        super(Race.Difficulty.EXTREME);
    }

    public double getBaseHealth() {
        return 8.0;
    }

    public double getBaseAttackDamage() {
        return 0.2;
    }

    public double getBaseAttackSpeed() {
        return 4.0;
    }

    public double getKnockbackResistance() {
        return 0.0;
    }

    public float getPlayerSize() {
        return 0.5f;
    }

    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)0.25);
    }

    public double getMovementSpeed() {
        return 0.125;
    }

    public double getSprintSpeed() {
        return 0.2;
    }

    public double getSpiritualHealthMultiplier() {
        return 2.0;
    }

    public double getAdditionalSpiritualHealth() {
        return 20.0;
    }

    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)300.0, (Object)500.0);
    }

    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)3000.0, (Object)3500.0);
    }

    public ResourceKey<Level> getRespawnDimension() {
        return MysticismDimensions.ELEMENTAL_REALM;
    }

    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)ExtraSkills.CHANT_ANNULMENT.get());
        list.add((TensuraSkill)ResistanceSkills.PHYSICAL_ATTACK_RESISTANCE.get());
        list.add((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.IntrinsicSkills.CONTRACT.get());
        list.add((TensuraSkill)IntrinsicSkills.POSSESSION.get());
        return list;
    }

    @Override
    public boolean isSpirit() {
        return true;
    }

    public boolean isSpiritual() {
        return true;
    }

    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.MEDIUM_SPIRIT);
    }

    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SPIRIT_LORD);
    }

    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.MEDIUM_SPIRIT);
    }

    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.MEDIUM_SPIRIT));
        MagicElemental element = MysticismPlayerCapability.getElement(player);
        if (element != null) {
            switch (element) {
                case EARTH: 
                case WIND: 
                case WATER: {
                    list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.PIXIE));
                }
            }
            return list;
        }
        MagicElemental[] elements = MagicElemental.values();
        MagicElemental randomElement = elements[new Random().nextInt(elements.length)];
        if (player.f_19853_.f_46443_) {
            MysticismNetwork.sendToServer(new IntrinsicSkillsRequestPacket(randomElement.getNamespace()));
        } else {
            ArrayList<TensuraSkill> skillList = new ArrayList<TensuraSkill>();
            element = MagicElemental.valueOf((String)randomElement.name());
            IntrinsicSkillsRequestPacket.assignElementAndSkills(player, skillList, element);
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
            for (TensuraSkill skill : skillList) {
                storage.learnSkill((ManasSkill)skill);
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
            TensuraSkillCapability.sync((Player)player);
            MysticismPlayerCapability.sync(player);
        }
        return new ArrayList<Race>();
    }

    public void raceAbility(Player entity) {
        if (!entity.m_5833_() && !entity.m_7500_()) {
            Level level = entity.m_9236_();
            if (entity.m_150110_().f_35936_) {
                entity.m_150110_().f_35936_ = false;
                entity.m_150110_().f_35935_ = false;
                entity.m_150110_().m_35943_(0.05f);
                entity.m_6885_();
            } else {
                entity.m_150110_().f_35936_ = true;
                entity.m_150110_().f_35935_ = true;
                entity.m_150110_().m_35943_(0.025f);
                entity.m_6885_();
            }
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

