/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.elemental;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.elemental.LesserSpiritRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IForgeRegistry;

public class MediumSpiritRace
extends LesserSpiritRace {
    @Override
    public double getBaseHealth() {
        return 80.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 4.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.2;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)0.5);
    }

    @Override
    public double getSprintSpeed() {
        return 0.4;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 4.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)1000.0, (Object)1000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)2000.0, (Object)2000.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_SPIRIT);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SPIRIT_LORD);
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_SPIRIT);
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_SPIRIT));
        return list;
    }

    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.LESSER_SPIRIT));
        return list;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        MagicElemental element = MysticismPlayerCapability.getElement(player);
        if (element == null) {
            return list;
        }
        switch (element) {
            case DARKNESS: {
                list.add((TensuraSkill)IntrinsicSkills.DARKNESS_TRANSFORM.get());
                break;
            }
            case EARTH: {
                list.add((TensuraSkill)IntrinsicSkills.EARTH_TRANSFORM.get());
                break;
            }
            case FLAME: {
                list.add((TensuraSkill)IntrinsicSkills.FLAME_TRANSFORM.get());
                break;
            }
            case LIGHT: {
                list.add((TensuraSkill)IntrinsicSkills.LIGHT_TRANSFORM.get());
                break;
            }
            case SPACE: {
                list.add((TensuraSkill)IntrinsicSkills.SPACE_TRANSFORM.get());
                break;
            }
            case WATER: {
                list.add((TensuraSkill)IntrinsicSkills.WATER_TRANSFORM.get());
                break;
            }
            case WIND: {
                list.add((TensuraSkill)IntrinsicSkills.WIND_TRANSFORM.get());
            }
        }
        return list;
    }

    public double getEvolutionPercentage(Player player) {
        return TensuraPlayerCapability.getBaseEP((Player)player) * 100.0 / (Double)MysticismConfig.INSTANCE.racesConfig.epToMediumSpirit.get();
    }

    @Override
    public void raceAbility(Player entity) {
        if (!entity.m_5833_() && !entity.m_7500_()) {
            Level level = entity.m_9236_();
            if (entity.m_150110_().f_35936_) {
                entity.m_150110_().f_35936_ = false;
                entity.m_150110_().f_35935_ = false;
                entity.m_150110_().m_35943_(0.05f);
                entity.m_6885_();
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                entity.m_150110_().f_35936_ = true;
                entity.m_150110_().f_35935_ = true;
                entity.m_150110_().m_35943_(0.05f);
                entity.m_6885_();
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

