/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.elemental;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.elemental.LesserSpiritRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class PixieRace
extends LesserSpiritRace {
    @Override
    public double getBaseHealth() {
        return 20.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 0.5;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.3;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.2;
    }

    @Override
    public float getPlayerSize() {
        return 0.5f;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)0.5);
    }

    @Override
    public double getMovementSpeed() {
        return 0.2;
    }

    @Override
    public double getSprintSpeed() {
        return 0.4;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 4.0;
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 120.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)2000.0, (Object)2000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)3000.0, (Object)3000.0);
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)CommonSkills.TELEPATHY.get());
        MagicElemental element = MysticismPlayerCapability.getElement(player);
        if (element == null) {
            return list;
        }
        switch (element) {
            case EARTH: {
                list.add((TensuraSkill)IntrinsicSkills.EARTH_TRANSFORM.get());
                break;
            }
            case WATER: {
                list.add((TensuraSkill)IntrinsicSkills.WATER_TRANSFORM.get());
                break;
            }
            case WIND: {
                list.add((TensuraSkill)IntrinsicSkills.WIND_TRANSFORM.get());
            }
        }
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DRYAD);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.VERDANT_LORD);
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DRYAD);
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DRYAD));
        return list;
    }

    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.LESSER_SPIRIT));
        return list;
    }

    public double getEvolutionPercentage(Player player) {
        return TensuraPlayerCapability.getBaseEP((Player)player) * 100.0 / (Double)MysticismConfig.INSTANCE.racesConfig.epToPixie.get();
    }
}

