/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.elemental;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.elemental.GreaterSpiritRace;
import io.github.Memoires.trmysticism.registry.magic.MysticismSpiritualMagics;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class SpiritLordRace
extends GreaterSpiritRace {
    @Override
    public double getBaseHealth() {
        return 3000.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 15.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.8;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)1.0);
    }

    @Override
    public double getSprintSpeed() {
        return 1.6;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 8.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)500000.0, (Object)500000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)500000.0, (Object)500000.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.ELEMENTAL_QUEEN);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.ELEMENTAL_QUEEN);
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)ResistanceSkills.MAGIC_RESISTANCE.get());
        MagicElemental element = MysticismPlayerCapability.getElement(player);
        if (element == null) {
            return list;
        }
        if (element == MagicElemental.SPACE) {
            list.add((TensuraSkill)MysticismSpiritualMagics.SPATIAL_VOID.get());
        }
        return list;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.ELEMENTAL_QUEEN));
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_SPIRIT));
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        return TensuraPlayerCapability.getBaseEP((Player)player) * 100.0 / (Double)MysticismConfig.INSTANCE.racesConfig.epToSpiritLord.get();
    }
}

