/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.insect.ant.fire;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.insect.ant.fire.FireAntInsectarRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class FlameSoulInsectRace
extends FireAntInsectarRace {
    @Override
    public double getBaseHealth() {
        return 2500.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 4.5;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.25;
    }

    @Override
    public double getKnockbackResistance() {
        return 1.0;
    }

    @Override
    public float getPlayerSize() {
        return 1.0f;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)2.0);
    }

    @Override
    public double getMovementSpeed() {
        return 0.2;
    }

    @Override
    public double getSprintSpeed() {
        return 0.17;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)400000.0, (Object)400000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)400000.0, (Object)400000.0);
    }

    @Override
    public boolean isMajin() {
        return true;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 5.0;
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 420.0;
    }

    public boolean isSpiritual() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)IntrinsicSkills.FLAME_TRANSFORM.get());
        list.add((TensuraSkill)ResistanceSkills.FLAME_ATTACK_RESISTANCE.get());
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_FIRE_ANT);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_FIRE_ANT);
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_FIRE_ANT));
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.FIRE_ANT_INSECTAR));
        return list;
    }

    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        list.add((Component)Component.m_237115_((String)"trmysticism.evolution.have_flame_manipulation"));
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double ep = player.m_9236_().m_46469_().m_46207_(MysticismGamerules.INSECT_EP_SPLIT) ? Math.min(TensuraPlayerCapability.getBaseEP((Player)player) * 50.0 / (Double)MysticismConfig.INSTANCE.racesConfig.epToFlameSoulInsect.get(), 50.0) : Math.min(TensuraPlayerCapability.getBaseEP((Player)player) * 50.0 / (Double)MysticismConfig.INSTANCE.racesConfig.epToSoulInsect.get(), 50.0);
        double skill = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.skillForFlameSoulInsect.get()), player);
        return ep + skill;
    }

    private double calculateSkillContribution(ResourceLocation skillLocation, Player player) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional optionalSkill = storage.getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(skillLocation));
        if (optionalSkill.isPresent()) {
            return 50.0;
        }
        return 0.0;
    }
}

