/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.insect.beetle.drone;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.insect.beetle.drone.DroneBeetleInsectarRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import io.github.Memoires.trmysticism.registry.skill.IntrinsicSkills;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class LightningSoulInsectRace
extends DroneBeetleInsectarRace {
    @Override
    public double getBaseHealth() {
        return 2500.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 4.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 6.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.6;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)2.0);
    }

    @Override
    public double getMovementSpeed() {
        return 0.3;
    }

    @Override
    public double getSprintSpeed() {
        return 0.9;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)400000.0, (Object)400000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)400000.0, (Object)400000.0);
    }

    @Override
    public boolean isMajin() {
        return true;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 5.0;
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 20.0;
    }

    public boolean isSpiritual() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)IntrinsicSkills.LIGHTNING_MODE.get());
        list.add((TensuraSkill)ResistanceSkills.PHYSICAL_ATTACK_RESISTANCE.get());
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_DRONE_BEETLE);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_DRONE_BEETLE);
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DIVINE_DRONE_BEETLE));
        return list;
    }

    @Override
    public void raceAbility(Player entity) {
        if (!entity.m_5833_() && !entity.m_7500_()) {
            Level level = entity.m_9236_();
            if (entity.m_150110_().f_35936_) {
                entity.m_150110_().f_35936_ = false;
                entity.m_150110_().f_35935_ = false;
                entity.m_150110_().m_35943_(0.05f);
            } else {
                entity.m_150110_().f_35936_ = true;
                entity.m_150110_().f_35935_ = true;
                entity.m_150110_().m_35943_(0.06f);
            }
            entity.m_6885_();
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        list.add((Component)Component.m_237115_((String)"trmysticism.evolution.have_lightning_manipulation"));
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double ep = player.m_9236_().m_46469_().m_46207_(MysticismGamerules.INSECT_EP_SPLIT) ? Math.min(TensuraPlayerCapability.getBaseEP((Player)player) * 50.0 / (Double)MysticismConfig.INSTANCE.racesConfig.epToLightningSoulInsect.get(), 50.0) : Math.min(TensuraPlayerCapability.getBaseEP((Player)player) * 50.0 / (Double)MysticismConfig.INSTANCE.racesConfig.epToSoulInsect.get(), 50.0);
        double skill = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.skillForLightningSoulInsect.get()), player);
        return ep + skill;
    }

    private double calculateSkillContribution(ResourceLocation skillLocation, Player player) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional optionalSkill = storage.getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(skillLocation));
        if (optionalSkill.isPresent()) {
            return 50.0;
        }
        return 0.0;
    }
}

