/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.sculk.charged;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.capability.race.IMysticismPlayerCapability;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.sculk.SculkWormRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargedPerforatorRace
extends SculkWormRace {
    @Override
    public double getBaseHealth() {
        return 75.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 5.0;
    }

    @Override
    public float getPlayerSize() {
        return 1.0f;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.2;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)2.0);
    }

    @Override
    public double getSprintSpeed() {
        return 0.5;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 3.0;
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 35.0;
    }

    @Override
    @NotNull
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)10000.0, (Object)10000.0);
    }

    @Override
    @NotNull
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)10000.0, (Object)10000.0);
    }

    public double getEvolutionPercentage(Player player) {
        IMysticismPlayerCapability cap = (IMysticismPlayerCapability)player.getCapability(MysticismPlayerCapability.CAPABILITY).orElseThrow(() -> new IllegalStateException("LightningStrike capability not found!"));
        double requiredStrikes = ((Integer)MysticismConfig.INSTANCE.racesConfig.lightningStrikesForChargedPerforator.get()).doubleValue();
        double currentStrikes = cap.getLightningStrikes();
        double currentEP = TensuraPlayerCapability.getBaseEP((Player)player);
        double requiredEP = (Double)MysticismConfig.INSTANCE.racesConfig.epToGreaterGlacierWyrm.get();
        double strikeRatio = Math.min(1.0, currentStrikes / requiredStrikes);
        double epRatio = Math.min(1.0, currentEP / requiredEP);
        double percentage = (strikeRatio + epRatio) / 2.0 * 100.0;
        return percentage;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)ExtraSkills.LIGHTNING_MANIPULATION.get());
        list.add((TensuraSkill)ResistanceSkills.ELECTRICITY_RESISTANCE.get());
        list.add((TensuraSkill)ResistanceSkills.HEAT_RESISTANCE.get());
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.OVERLOADING_WORM);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.LIGHTNING_ABERRATION);
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.OVERLOADING_WORM));
        return list;
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.OVERLOADING_WORM);
    }

    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SCULK_WORM));
        return list;
    }

    @Override
    public void raceTick(Player player) {
    }

    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        list.add((Component)Component.m_237115_((String)"trmysticism.evolution_menu.lightning_strike.requirement"));
        list.add((Component)Component.m_237115_((String)"trmysticism.configurable"));
        return list;
    }
}

