/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.tengu;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class TenguRace
extends Race {
    public TenguRace() {
        super(Race.Difficulty.EASY);
    }

    public double getBaseHealth() {
        return 300.0;
    }

    public float getPlayerSize() {
        return 2.0f;
    }

    public double getBaseAttackDamage() {
        return 3.0;
    }

    public double getBaseAttackSpeed() {
        return 3.5;
    }

    public double getKnockbackResistance() {
        return 0.2;
    }

    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer();
    }

    public double getMovementSpeed() {
        return 0.1;
    }

    public double getSprintSpeed() {
        return 0.5;
    }

    public double getAdditionalSpiritualHealth() {
        return 30.0;
    }

    public double getSpiritualHealthMultiplier() {
        return 2.5;
    }

    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)100000.0, (Object)150000.0);
    }

    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)100000.0, (Object)150000.0);
    }

    public boolean isSpiritual() {
        return false;
    }

    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.TENGU_SAINT);
    }

    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.TENGU_SAINT);
    }

    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_ANGEL));
        return list;
    }

    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.TENGU_SAINT));
        return list;
    }

    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)IntrinsicSkills.BEAST_TRANSFORMATION.get());
        list.add((TensuraSkill)CommonSkills.SELF_REGENERATION.get());
        return list;
    }

    public void triggerEvolutionRewards(Player player) {
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
            if (this.getManaEvolutionReward() > 10.0) {
                cap.setBaseMagicule(cap.getBaseMagicule() + this.getManaEvolutionReward(), (LivingEntity)player);
            } else if (cap.getBaseMagicule() < this.getMinBaseMagicule()) {
                cap.setBaseMagicule(this.getMinBaseMagicule(), (LivingEntity)player);
            }
            if (this.getAuraEvolutionReward() > 10.0) {
                cap.setBaseAura(cap.getBaseAura() + this.getAuraEvolutionReward(), (LivingEntity)player);
            } else if (cap.getBaseAura() < this.getMinBaseAura()) {
                cap.setBaseAura(this.getMinBaseAura(), (LivingEntity)player);
            }
            ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
            list.add((TensuraSkill)IntrinsicSkills.POSSESSION.get());
            list.add((TensuraSkill)IntrinsicSkills.LIGHT_TRANSFORM.get());
            list.forEach(skill -> SkillAPI.getSkillsFrom((Entity)player).forgetSkill((ManasSkill)skill));
        });
        player.m_21051_(Attributes.f_22276_).m_22100_(300.0);
        player.m_21153_(300.0f);
        TensuraPlayerCapability.sync((Player)player);
    }

    public void raceAbility(Player entity) {
        if (!entity.m_6047_() && !entity.m_20142_()) {
            Level level = entity.m_9236_();
            if (entity.m_150110_().f_35935_) {
                entity.m_150110_().f_35935_ = false;
                entity.m_150110_().f_35936_ = false;
                entity.m_6885_();
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                entity.m_150110_().f_35935_ = true;
                entity.m_150110_().f_35936_ = true;
                entity.m_6885_();
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public boolean hasGuaranteeElemental() {
        return true;
    }

    public double getElementalSpiritsChance(MagicElemental elemental, SpiritualMagic.SpiritLevel level) {
        if (elemental.equals((Object)MagicElemental.LIGHT)) {
            return level.equals((Object)SpiritualMagic.SpiritLevel.LESSER) ? 100.0 : super.getElementalSpiritsChance(elemental, level) * 2.0;
        }
        return super.getElementalSpiritsChance(elemental, level);
    }
}

