/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.wyrm.glacier.drake;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.wyrm.glacier.drake.RimefangDrakeRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class RimeBlightHydraRace
extends RimefangDrakeRace {
    @Override
    public double getBaseHealth() {
        return 6000.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 10.0;
    }

    @Override
    public float getPlayerSize() {
        return 3.2f;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 5.5;
    }

    @Override
    public double getSprintSpeed() {
        return 1.2;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)3.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)1200000.0, (Object)1200000.0);
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)800000.0, (Object)800000.0);
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double baseEP = Math.min(TensuraPlayerCapability.getBaseEP((Player)player) * 33.4 / (Double)MysticismConfig.INSTANCE.racesConfig.epToRimeblightHydra.get(), 33.4);
        double skillContribution1 = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.firstSkillforRimeblightHydra.get()), (Integer)MysticismConfig.INSTANCE.racesConfig.firstskillMasteryForRimeblightHydra.get(), player);
        double skillContribution2 = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.secondSkillforRimeblightHydra.get()), (Integer)MysticismConfig.INSTANCE.racesConfig.secondskillMasteryForRimeblightHydra.get(), player);
        return baseEP + skillContribution1 + skillContribution2;
    }

    private double calculateSkillContribution(ResourceLocation skillLocation, int masteryThreshold, Player player) {
        ManasSkillInstance instance;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional optionalSkill = storage.getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(skillLocation));
        if (optionalSkill.isPresent() && (instance = (ManasSkillInstance)optionalSkill.get()).getMastery() >= masteryThreshold) {
            return 33.33;
        }
        return 0.0;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.FROSTCOIL_SEA_SERPENT));
        return list;
    }

    public boolean isDivine() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)ExtraSkills.INFINITE_REGENERATION.get());
        list.add((TensuraSkill)IntrinsicSkills.DRAGON_MODE.get());
        list.add((TensuraSkill)IntrinsicSkills.DIVINE_KI_RELEASE.get());
        list.add((TensuraSkill)IntrinsicSkills.PARALYSING_BREATH.get());
        list.add((TensuraSkill)IntrinsicSkills.POISONOUS_BREATH.get());
        return list;
    }

    public void raceAbility(Player entity) {
        if (!entity.m_5833_() && !entity.m_7500_()) {
            Level level = entity.m_9236_();
            if (entity.m_150110_().f_35936_) {
                entity.m_150110_().f_35936_ = false;
                entity.m_150110_().f_35935_ = false;
                entity.m_150110_().m_35943_(0.075f);
                entity.m_6885_();
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                entity.m_150110_().f_35936_ = true;
                entity.m_150110_().f_35935_ = true;
                entity.m_150110_().m_35943_(0.075f);
                entity.m_6885_();
                level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        return new ArrayList<Race>();
    }

    @Override
    public Race getDefaultEvolution(Player player) {
        return null;
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return null;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        list.add((Component)Component.m_237115_((String)"trmysticism.evolution.dragon_eye.mastery"));
        list.add((Component)Component.m_237115_((String)"trmysticism.evolution.ice_domination.mastery"));
        list.add((Component)Component.m_237115_((String)"trmysticism.configurable"));
        return list;
    }
}

