/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.wyrm.glacier.serpent;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.wyrm.glacier.GreaterGlacierWyrmRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class FrostcoilSeaSerpentRace
extends GreaterGlacierWyrmRace {
    @Override
    public double getBaseHealth() {
        return 460.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 8.0;
    }

    @Override
    public float getPlayerSize() {
        return 3.0f;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 5.0;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)1.5);
    }

    @Override
    public double getSprintSpeed() {
        return 1.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)200000.0, (Object)200000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)150000.0, (Object)150000.0);
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)CommonSkills.HYDRAULIC_PROPULSION.get());
        list.add((TensuraSkill)IntrinsicSkills.ULTRASONIC_WAVES.get());
        list.add((TensuraSkill)IntrinsicSkills.DRAGON_EAR.get());
        list.add((TensuraSkill)IntrinsicSkills.DRAGON_SKIN.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double baseEP = Math.min(TensuraPlayerCapability.getBaseEP((Player)player) * 33.4 / (Double)MysticismConfig.INSTANCE.racesConfig.epToFrostcoilSeaSerpent.get(), 33.4);
        double skillContribution1 = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.firstSkillforFrostcoilSeaSerpent.get()), (Integer)MysticismConfig.INSTANCE.racesConfig.firstskillMasteryForFrostcoilSeaSerpent.get(), player);
        double skillContribution2 = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.secondSkillforFrostcoilSeaSerpent.get()), (Integer)MysticismConfig.INSTANCE.racesConfig.secondskillMasteryForFrostcoilSeaSerpent.get(), player);
        return baseEP + skillContribution1 + skillContribution2;
    }

    private double calculateSkillContribution(ResourceLocation skillLocation, int masteryThreshold, Player player) {
        ManasSkillInstance instance;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional optionalSkill = storage.getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(skillLocation));
        if (optionalSkill.isPresent() && (instance = (ManasSkillInstance)optionalSkill.get()).getMastery() >= masteryThreshold) {
            return 33.33;
        }
        return 0.0;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        list.add((Component)Component.m_237115_((String)"trmysticism.evolution.water_manipulation.mastery"));
        list.add((Component)Component.m_237115_((String)"trmysticism.evolution.cryogenic_cessation.mastery"));
        list.add((Component)Component.m_237115_((String)"trmysticism.configurable"));
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_GLACIER_WYRM));
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.FROSTWROUGHT_LEVIATHAN);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.FROSTWROUGHT_LEVIATHAN);
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.FROSTWROUGHT_LEVIATHAN));
        return list;
    }

    public boolean isSpiritual() {
        return true;
    }
}

