/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.wyrm.pyre.scorch;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.wyrm.pyre.GreaterPyreWyrmRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class ScorchtailSalamanderRace
extends GreaterPyreWyrmRace {
    @Override
    public double getBaseHealth() {
        return 700.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 7.5;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.8;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)2.0);
    }

    @Override
    public double getSprintSpeed() {
        return 1.1;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)100000.0, (Object)100000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)150000.0, (Object)150000.0);
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)IntrinsicSkills.FLAME_TRANSFORM.get());
        list.add((TensuraSkill)IntrinsicSkills.DRAGON_EYE.get());
        list.add((TensuraSkill)IntrinsicSkills.DRAGON_SKIN.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double baseEP = Math.min(TensuraPlayerCapability.getBaseEP((Player)player) * 33.4 / (Double)MysticismConfig.INSTANCE.racesConfig.epToScorchtailSalamander.get(), 33.4);
        double skillContribution1 = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.firstSkillforScorchtailSalamander.get()), (Integer)MysticismConfig.INSTANCE.racesConfig.firstskillMasteryForScorchtailSalamander.get(), player);
        double skillContribution2 = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.secondSkillforScorchtailSalamander.get()), (Integer)MysticismConfig.INSTANCE.racesConfig.secondskillMasteryForScorchtailSalamander.get(), player);
        return baseEP + skillContribution1 + skillContribution2;
    }

    private double calculateSkillContribution(ResourceLocation skillLocation, int masteryThreshold, Player player) {
        ManasSkillInstance instance;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional optionalSkill = storage.getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(skillLocation));
        if (optionalSkill.isPresent() && (instance = (ManasSkillInstance)optionalSkill.get()).getMastery() >= masteryThreshold) {
            return 33.33;
        }
        return 0.0;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        list.add((Component)Component.m_237115_((String)"trmysticism.evolution.flame_manipulation.mastery"));
        list.add((Component)Component.m_237115_((String)"trmysticism.evolution.profaned_prominence.mastery"));
        list.add((Component)Component.m_237115_((String)"trmysticism.configurable"));
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_PYRE_WYRM));
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SCORCHTALON_WYVERN);
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SCORCHTALON_WYVERN);
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SCORCHTALON_WYVERN));
        return list;
    }

    public boolean isMajin() {
        return true;
    }
}

