/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.race.wyrm.pyre.scorch;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.race.wyrm.pyre.scorch.ScorchtailSalamanderRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class ScorchtalonWyvernRace
extends ScorchtailSalamanderRace {
    @Override
    public double getBaseHealth() {
        return 5000.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 9.0;
    }

    @Override
    public float getPlayerSize() {
        return 3.0f;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 6.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 3.5;
    }

    @Override
    public double getSprintSpeed() {
        return 1.11;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer((double)4.0);
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)500000.0, (Object)500000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)1500000.0, (Object)1500000.0);
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double baseEP = Math.min(TensuraPlayerCapability.getBaseEP((Player)player) * 33.4 / (Double)MysticismConfig.INSTANCE.racesConfig.epToScorchtalonWyvern.get(), 33.4);
        double skillContribution1 = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.firstSkillforScorchtalonWyvern.get()), (Integer)MysticismConfig.INSTANCE.racesConfig.firstskillMasteryForScorchtalonWyvern.get(), player);
        double skillContribution2 = this.calculateSkillContribution(new ResourceLocation((String)MysticismConfig.INSTANCE.racesConfig.secondSkillforScorchtalonWyvern.get()), (Integer)MysticismConfig.INSTANCE.racesConfig.secondskillMasteryForScorchtalonWyvern.get(), player);
        return baseEP + skillContribution1 + skillContribution2;
    }

    private double calculateSkillContribution(ResourceLocation skillLocation, int masteryThreshold, Player player) {
        ManasSkillInstance instance;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional optionalSkill = storage.getSkill((ManasSkill)SkillAPI.getSkillRegistry().getValue(skillLocation));
        if (optionalSkill.isPresent() && (instance = (ManasSkillInstance)optionalSkill.get()).getMastery() >= masteryThreshold) {
            return 33.33;
        }
        return 0.0;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SCORCHTAIL_SALAMANDER));
        return list;
    }

    public boolean isDivine() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)IntrinsicSkills.DRAGON_MODE.get());
        list.add((TensuraSkill)IntrinsicSkills.DIVINE_KI_RELEASE.get());
        return list;
    }

    public void raceAbility(Player player) {
        if (player.m_20096_()) {
            Vec3 delta = player.m_20184_();
            double dy = delta.f_82480_ <= 0.0 ? 0.5 : delta.f_82480_ + 0.5;
            player.m_20256_(new Vec3(delta.m_7096_(), dy, delta.m_7094_()));
        }
        SkillHelper.riptidePush((LivingEntity)player, (float)0.75f);
        player.f_19864_ = true;
        player.f_19812_ = true;
        player.m_36320_();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        return new ArrayList<Race>();
    }

    @Override
    public Race getDefaultEvolution(Player player) {
        return null;
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return null;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        list.add((Component)Component.m_237115_((String)"trmysticism.evolution.flame_domination.mastery"));
        list.add((Component)Component.m_237115_((String)"trmysticism.evolution.dragon_skin.mastery"));
        list.add((Component)Component.m_237115_((String)"trmysticism.configurable"));
        return list;
    }

    public boolean canFly() {
        return true;
    }
}

