/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.registry.blocks;

import com.github.manasmods.manascore.api.data.gen.annotation.GenerateBlockLoot;
import com.github.manasmods.manascore.api.data.gen.annotation.GenerateBlockModels;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import io.github.Memoires.trmysticism.block.ElementalRealmPortalBlock;
import io.github.Memoires.trmysticism.registry.items.MysticismItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@GenerateBlockModels
@GenerateBlockLoot
public class MysticismBlocks {
    public static final RegistryObject<Block> ELEMENTAL_REALM_PORTAL;
    @GenerateBlockLoot.WithLootTables
    private static final DeferredRegister<Block> BLOCKS;
    @GenerateBlockModels.CubeAllModel
    public static final RegistryObject<Block> ICE_ORE;

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, CreativeModeTab tab) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        MysticismBlocks.registerBlockItem(name, toReturn, tab);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block, CreativeModeTab tab) {
        return MysticismItems.TENSURA_ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
    }

    public static void register(IEventBus eventBus) {
        Items.registry.register(eventBus);
        BLOCKS.register(eventBus);
    }

    static {
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"trmysticism");
        ELEMENTAL_REALM_PORTAL = BLOCKS.register("elemental_realm_portal", ElementalRealmPortalBlock::new);
        ICE_ORE = MysticismBlocks.registerBlock("ice_ore", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76276_).m_60978_(3.0f).m_60911_(0.98f).m_60918_(SoundType.f_56744_)), TensuraCreativeTab.BLOCKS);
    }

    public static class Items {
        private static final DeferredRegister<Item> registry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"trmysticism");
        public static final RegistryObject<Item> ELEMENTAL_REALM_PORTAL = Items.realmBlockItem(ELEMENTAL_REALM_PORTAL);

        public static <T extends Block> RegistryObject<Item> realmBlockItem(RegistryObject<T> block) {
            return TensuraBlocks.Items.fireResistedBlockItem(block, (CreativeModeTab)TensuraCreativeTab.DUNGEON_BLOCKS);
        }
    }
}

