/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.registry.dimensions;

import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class ElementalRealmTeleporter
implements ITeleporter {
    private final boolean setSpawn;

    public ElementalRealmTeleporter(boolean setSpawn) {
        this.setSpawn = setSpawn;
    }

    public boolean isVanilla() {
        return false;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        ServerPlayer player;
        entity.f_19802_ = 60;
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            if (destWorld.m_46472_() == MysticismDimensions.ELEMENTAL_REALM) {
                BlockPos respawnPos;
                BlockPos pos = entity.m_20183_();
                if (player.m_8963_() == destWorld.m_46472_() && (respawnPos = player.m_8961_()) != null) {
                    Optional optional = Player.m_36130_((ServerLevel)destWorld, (BlockPos)respawnPos, (float)player.m_8962_(), (boolean)player.m_8964_(), (boolean)true);
                    pos = optional.map(BlockPos::new).orElse(respawnPos);
                }
                if (!destWorld.m_8055_(pos.m_7494_()).m_60795_() || destWorld.m_8055_(pos.m_7495_()).m_60795_()) {
                    int yHeight = destWorld.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
                    if (yHeight < 10) {
                        yHeight = 128;
                    }
                    if (destWorld.m_8055_((pos = pos.m_175288_(yHeight)).m_7495_()).m_60795_()) {
                        ElementalRealmTeleporter.makeStonePlatform(destWorld, pos);
                    }
                }
                if (this.setSpawn) {
                    player.m_9158_(destWorld.m_46472_(), pos, player.m_146908_(), true, false);
                }
                return new PortalInfo(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), Vec3.f_82478_, 0.0f, 0.0f);
            }
            if (destWorld.m_46472_() == TensuraDimensions.LABYRINTH) {
                return new PortalInfo(new Vec3(-88.015, 185.0, 641.023), Vec3.f_82478_, player.m_8962_(), 0.0f);
            }
        }
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).m_8963_() == destWorld.m_46472_()) {
            BlockPos pos = player.m_8961_();
            if (pos != null) {
                Optional optional = Player.m_36130_((ServerLevel)destWorld, (BlockPos)pos, (float)player.m_8962_(), (boolean)player.m_8964_(), (boolean)true);
                if (optional.isPresent()) {
                    pos = new BlockPos((Vec3)optional.get());
                }
            } else {
                pos = destWorld.m_220360_();
            }
            if (!destWorld.m_8055_(pos.m_7494_()).m_60795_()) {
                int yHeight = destWorld.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
                if (yHeight < 10) {
                    yHeight = 128;
                }
                if (destWorld.m_8055_((pos = pos.m_175288_(yHeight)).m_7495_()).m_60795_()) {
                    ElementalRealmTeleporter.makeSolidSpacePlatform(destWorld, pos);
                }
            }
            if (this.setSpawn) {
                player.m_9158_(destWorld.m_46472_(), pos, player.m_146908_(), true, false);
            }
            return new PortalInfo(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), Vec3.f_82478_, player.m_8962_(), 0.0f);
        }
        BlockPos pos = entity.m_20183_();
        if (!destWorld.m_8055_(pos.m_7494_()).m_60795_()) {
            int yHeight = destWorld.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            if (yHeight < 10) {
                yHeight = 128;
            }
            if (destWorld.m_8055_((pos = pos.m_175288_(yHeight)).m_7495_()).m_60795_()) {
                ElementalRealmTeleporter.makeSolidSpacePlatform(destWorld, pos);
            }
        }
        return new PortalInfo(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    public static void makeStonePlatform(ServerLevel pServerLevel, BlockPos pos) {
        int i = pos.m_123341_();
        int j = pos.m_123342_() - 1;
        int k = pos.m_123343_();
        BlockPos.m_121976_((int)(i - 1), (int)(j + 1), (int)(k - 1), (int)(i + 1), (int)(j + 3), (int)(k + 1)).forEach(blockPos -> pServerLevel.m_46597_(blockPos, Blocks.f_50016_.m_49966_()));
        BlockPos.m_121976_((int)(i - 1), (int)j, (int)(k - 1), (int)(i + 1), (int)j, (int)(k + 1)).forEach(blockPos -> pServerLevel.m_46597_(blockPos, Blocks.f_50069_.m_49966_()));
    }

    public static void makeSolidSpacePlatform(ServerLevel pServerLevel, BlockPos pos) {
        int i = pos.m_123341_();
        int j = pos.m_123342_() - 1;
        int k = pos.m_123343_();
        BlockPos.m_121976_((int)(i - 1), (int)(j + 1), (int)(k - 1), (int)(i + 1), (int)(j + 3), (int)(k + 1)).forEach(blockPos -> {
            if (pServerLevel.m_8055_(blockPos).m_204336_(TensuraTags.Blocks.SKILL_BREAK_EASY)) {
                pServerLevel.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
            }
        });
        BlockPos.m_121976_((int)(i - 1), (int)j, (int)(k - 1), (int)(i + 1), (int)j, (int)(k + 1)).forEach(blockPos -> {
            BlockState state = pServerLevel.m_8055_(blockPos);
            if (state.m_60795_() || state.m_204336_(TensuraTags.Blocks.SKILL_BREAK_EASY)) {
                pServerLevel.m_46597_(blockPos, ((Block)TensuraBlocks.SOLID_SPACE.get()).m_49966_());
                pServerLevel.m_186460_(blockPos, (Block)TensuraBlocks.SOLID_SPACE.get(), 1200);
            }
        });
    }
}

