/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.registry.dimensions;

import com.google.common.collect.ImmutableSet;
import io.github.Memoires.trmysticism.registry.biome.MysticismBiomes;
import io.github.Memoires.trmysticism.registry.blocks.MysticismBlocks;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismNoises;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class MysticismDimensions {
    public static final DeferredRegister<PoiType> POI = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"trmysticism");
    public static final ResourceKey<Level> FANTASY_WORLD = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("trmysticism", "fantasy_world"));
    public static final ResourceKey<DimensionType> FANTASY_WORLD_TYPE = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)FANTASY_WORLD.m_135782_());
    public static final DeferredRegister<NoiseGeneratorSettings> NOISE = DeferredRegister.create((ResourceKey)Registry.f_122878_, (String)"trmysticism");
    public static final ResourceKey<Level> ELEMENTAL_REALM = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("trmysticism", "elemental_realm"));
    public static final ResourceKey<DimensionType> ELEMENTAL_REALM_TYPE = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)ELEMENTAL_REALM.m_135782_());
    public static final RegistryObject<NoiseGeneratorSettings> ELEMENTAL_REALM_NOISE = NOISE.register("elemental_realm", () -> GenerationNoises.ELEMENTAL_REALM);
    public static final RegistryObject<PoiType> ELEMENTAL_REALM_PORTAL = POI.register("elemental_realm_portal", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)MysticismBlocks.ELEMENTAL_REALM_PORTAL.get()).m_49965_().m_61056_()), 0, 1));

    public static void register(IEventBus modEventBus) {
        POI.register(modEventBus);
        NOISE.register(modEventBus);
    }

    public static class GenerationNoises
    extends NoiseRouterData {
        private static final DensityFunction ZERO = DensityFunctions.m_208263_();
        public static final NoiseGeneratorSettings ELEMENTAL_REALM = new NoiseGeneratorSettings(NoiseSettings.m_224525_((int)-32, (int)256, (int)2, (int)2), Blocks.f_152491_.m_49966_(), Blocks.f_50016_.m_49966_(), GenerationNoises.elementalRealm(), Rules.ELEMENTAL_REALM_DIMENSION, List.of(), 64, false, false, false, false);

        private static Holder<NormalNoise.NoiseParameters> m_209542_(ResourceKey<NormalNoise.NoiseParameters> key) {
            return BuiltinRegistries.f_194654_.m_206081_(key);
        }

        private static DensityFunction m_224443_(DensityFunction func, int i, int i1, int i2, int i3, double v, int i4, int i5, double v1) {
            DensityFunction func1 = DensityFunctions.m_208266_((int)(i + i1 - i2), (int)(i + i1 - i3), (double)1.0, (double)0.0);
            DensityFunction toReturn = DensityFunctions.m_224030_((DensityFunction)func1, (double)v, (DensityFunction)func);
            DensityFunction func2 = DensityFunctions.m_208266_((int)(i + i4), (int)(i + i5), (double)0.0, (double)1.0);
            toReturn = DensityFunctions.m_224030_((DensityFunction)func2, (double)v1, (DensityFunction)toReturn);
            return toReturn;
        }

        private static DensityFunction m_224439_(DensityFunction func, int i, int i1) {
            return GenerationNoises.m_224443_(func, i, i1, 72, -184, -23.4375, 4, 32, -0.234375);
        }

        private static NoiseRouter elementalRealm() {
            DensityFunction uFunc1 = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208373_((DensityFunction)DensityFunctions.m_208366_(GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189286_))));
            DensityFunction uFunc2 = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208373_((DensityFunction)DensityFunctions.m_208378_(GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189286_))));
            DensityFunction temperature = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)uFunc1, (DensityFunction)uFunc2, (double)0.25, GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189269_)));
            DensityFunction vegetation = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)uFunc1, (DensityFunction)uFunc2, (double)0.25, GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189278_)));
            DensityFunction continentalness = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)uFunc1, (DensityFunction)uFunc2, (double)0.25, GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189279_)));
            DensityFunction erosion = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)uFunc1, (DensityFunction)uFunc2, (double)0.25, GenerationNoises.m_209542_((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189280_)));
            DensityFunction baseNoise = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.1), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208266_((int)0, (int)128, (double)0.0, (double)1.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.5), (DensityFunction)DensityFunctions.m_208368_((Holder)((Holder)MysticismNoises.ELEMENTAL_REALM.getHolder().orElseThrow()), (double)0.5, (double)1.0))));
            DensityFunction finalDensity = DensityFunctions.m_208281_((DensityFunction)DensityFunctions.m_208389_((DensityFunction)GenerationNoises.m_224439_(baseNoise, 0, 128))).m_208234_();
            return new NoiseRouter(ZERO, ZERO, ZERO, ZERO, temperature, vegetation, continentalness, erosion, ZERO, ZERO, ZERO, finalDensity, ZERO, ZERO, ZERO);
        }
    }

    public static class Rules {
        private static final SurfaceRules.RuleSource CLAY = Rules.makeStateRule(Blocks.f_50129_);
        private static final SurfaceRules.RuleSource SAND = Rules.makeStateRule(Blocks.f_49992_);
        private static final SurfaceRules.RuleSource DIRT = Rules.makeStateRule(Blocks.f_50493_);
        private static final SurfaceRules.RuleSource BLACKSTONE = Rules.makeStateRule(Blocks.f_50730_);
        private static final SurfaceRules.RuleSource MAGMA_BLOCK = Rules.makeStateRule(Blocks.f_50450_);
        private static final SurfaceRules.RuleSource BASALT = Rules.makeStateRule(Blocks.f_50137_);
        private static final SurfaceRules.RuleSource COARSE_DIRT = Rules.makeStateRule(Blocks.f_50546_);
        private static final SurfaceRules.RuleSource END_STONE = Rules.makeStateRule(Blocks.f_50259_);
        private static final SurfaceRules.RuleSource MOSS = Rules.makeStateRule(Blocks.f_152544_);
        private static final SurfaceRules.RuleSource STONE = Rules.makeStateRule(Blocks.f_50069_);
        private static final SurfaceRules.RuleSource MOSSY_STONE = Rules.makeStateRule(Blocks.f_50079_);
        private static final SurfaceRules.RuleSource RED_SAND = Rules.makeStateRule(Blocks.f_49993_);
        private static final SurfaceRules.RuleSource RED_SANDSTONE = Rules.makeStateRule(Blocks.f_50394_);
        private static final SurfaceRules.RuleSource SANDSTONE = Rules.makeStateRule(Blocks.f_50062_);
        private static final SurfaceRules.RuleSource BLACK_CONCRETE = Rules.makeStateRule(Blocks.f_50505_);
        private static final SurfaceRules.RuleSource BLACK_TERRACOTTA = Rules.makeStateRule(Blocks.f_50302_);
        private static final SurfaceRules.RuleSource WHITE_CONCRETE = Rules.makeStateRule(Blocks.f_50542_);
        private static final SurfaceRules.RuleSource QUARTZ_BLOCK = Rules.makeStateRule(Blocks.f_50333_);
        private static final SurfaceRules.RuleSource WHITE_TERRACOTTA = Rules.makeStateRule(Blocks.f_50287_);
        public static final SurfaceRules.RuleSource ELEMENTAL_REALM_DIMENSION = Rules.elementalRealm();

        private static SurfaceRules.RuleSource makeStateRule(Block block) {
            return SurfaceRules.m_189390_((BlockState)block.m_49966_());
        }

        private static SurfaceRules.RuleSource elementalRealm() {
            SurfaceRules.ConditionSource fireBiome = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticismBiomes.FIRE_BIOME.getKey()});
            SurfaceRules.ConditionSource waterBiome = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticismBiomes.WATER_BIOME.getKey()});
            SurfaceRules.ConditionSource spatialBiome = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticismBiomes.SPATIAL_BIOME.getKey()});
            SurfaceRules.ConditionSource windBiome = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticismBiomes.WIND_BIOME.getKey()});
            SurfaceRules.ConditionSource earthBiome = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticismBiomes.EARTH_BIOME.getKey()});
            SurfaceRules.ConditionSource darknessBiome = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticismBiomes.DARKNESS_BIOME.getKey()});
            SurfaceRules.ConditionSource lightBiome = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MysticismBiomes.LIGHT_BIOME.getKey()});
            SurfaceRules.RuleSource fireBiomeSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)BLACKSTONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)BASALT), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202170_, (SurfaceRules.RuleSource)MAGMA_BLOCK), BASALT});
            SurfaceRules.RuleSource waterBiomeSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SAND), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202170_, (SurfaceRules.RuleSource)DIRT), CLAY});
            SurfaceRules.RuleSource spatialBiomeSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)END_STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)END_STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202170_, (SurfaceRules.RuleSource)END_STONE), END_STONE});
            SurfaceRules.RuleSource windBiomeSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)MOSS), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)MOSSY_STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202170_, (SurfaceRules.RuleSource)STONE), MOSS});
            SurfaceRules.RuleSource earthBiomeSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)RED_SAND), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)RED_SANDSTONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202170_, (SurfaceRules.RuleSource)SANDSTONE), RED_SANDSTONE});
            SurfaceRules.RuleSource darknessBiomeSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)BLACK_CONCRETE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)BLACKSTONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202170_, (SurfaceRules.RuleSource)BLACK_TERRACOTTA), BLACK_CONCRETE});
            SurfaceRules.RuleSource lightBiomeSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)WHITE_CONCRETE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)QUARTZ_BLOCK), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_202170_, (SurfaceRules.RuleSource)WHITE_TERRACOTTA), WHITE_CONCRETE});
            return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)fireBiome, (SurfaceRules.RuleSource)fireBiomeSurface), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)waterBiome, (SurfaceRules.RuleSource)waterBiomeSurface), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)spatialBiome, (SurfaceRules.RuleSource)spatialBiomeSurface), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)windBiome, (SurfaceRules.RuleSource)windBiomeSurface), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)earthBiome, (SurfaceRules.RuleSource)earthBiomeSurface), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)darknessBiome, (SurfaceRules.RuleSource)darknessBiomeSurface), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)lightBiome, (SurfaceRules.RuleSource)lightBiomeSurface)});
        }
    }
}

