/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.util;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.skill.resist.DarknessAttackResistance;
import com.github.manasmods.tensura.ability.skill.resist.EarthAttackResistance;
import com.github.manasmods.tensura.ability.skill.resist.FireAttackResistance;
import com.github.manasmods.tensura.ability.skill.resist.LightAttackResistance;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.ability.skill.resist.SpatialAttackResistance;
import com.github.manasmods.tensura.ability.skill.resist.WaterAttackResistance;
import com.github.manasmods.tensura.ability.skill.resist.WindAttackResistance;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import io.github.Memoires.trmysticism.ability.magic.spiritual.space.SpatialVoidMagic;
import io.github.Memoires.trmysticism.registry.magic.MysticismSpiritualMagics;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.RegistryObject;

public final class ContractMagicTable {
    private static final List<Supplier<?>> ALL_SKILLS = List.of(SpiritualMagics.FIRE, SpiritualMagics.FIRE_BOLT, SpiritualMagics.FIRE_BREATH, SpiritualMagics.FLARE_CIRCLE, SpiritualMagics.HELLFIRE, SpiritualMagics.WIND, SpiritualMagics.WIND_BLADE, SpiritualMagics.LIGHTNING_LANCE, SpiritualMagics.AERIAL_BLADE, SpiritualMagics.ELECTRO_BLAST, SpiritualMagics.EARTH, SpiritualMagics.EARTH_SPIKES, SpiritualMagics.EARTH_STORM, SpiritualMagics.EARTH_JAIL, SpiritualMagics.MAGMA_SURGE, SpiritualMagics.LIGHT, SpiritualMagics.SOLAR_BEAM, SpiritualMagics.SOLAR_WAVE, SpiritualMagics.SOLAR_FLARE, SpiritualMagics.SOLAR_RAIN, SpiritualMagics.SPACE, SpiritualMagics.SHRINK, SpiritualMagics.TELEPORT, SpiritualMagics.GATE, SpiritualMagics.SWIPE, MysticismSpiritualMagics.SPATIAL_VOID, SpiritualMagics.WATER, SpiritualMagics.WATER_CUTTER, SpiritualMagics.ACID_RAIN, SpiritualMagics.BLIZZARD, SpiritualMagics.MEGIDDO, SpiritualMagics.DARKNESS, SpiritualMagics.DARK_CUBE, SpiritualMagics.SHADOW_BIND, SpiritualMagics.TRUE_DARKNESS, SpiritualMagics.DARKNESS_CANNON);
    private static final Map<MagicElemental, List<List<Supplier<?>>>> TABLE = new EnumMap(MagicElemental.class);

    private ContractMagicTable() {
    }

    public static void grant(ServerPlayer contractee, MagicElemental element, int tier) {
        if (tier >= 5) {
            ALL_SKILLS.forEach(s -> SkillUtils.learnSkill((LivingEntity)contractee, (ManasSkill)((ManasSkill)s.get()), (int)0));
            return;
        }
        List<List<Supplier<?>>> tiers = TABLE.get(element);
        if (tiers == null || tier < 1 || tier > tiers.size()) {
            return;
        }
        tiers.get(tier - 1).forEach(s -> SkillUtils.learnSkill((LivingEntity)contractee, (ManasSkill)((ManasSkill)s.get()), (int)0));
    }

    public static void revoke(ServerPlayer contractee, MagicElemental element, int tier) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)contractee);
        if (tier >= 5) {
            ALL_SKILLS.forEach(s -> storage.forgetSkill((ManasSkill)s.get()));
            storage.syncAll();
            return;
        }
        List<List<Supplier<?>>> tiers = TABLE.get(element);
        if (tiers == null || tier < 1 || tier > tiers.size()) {
            return;
        }
        tiers.get(tier - 1).forEach(s -> storage.forgetSkill((ManasSkill)s.get()));
        storage.syncAll();
    }

    public static void revokeMax(ServerPlayer contractee, MagicElemental element) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)contractee);
        if (!TABLE.containsKey(element)) {
            return;
        }
        TABLE.get(element).forEach(list -> list.forEach(s -> storage.forgetSkill((ManasSkill)s.get())));
        storage.syncAll();
    }

    public static int spiritTier(int spiritLevel) {
        return spiritLevel;
    }

    public static void revokeAll(ServerPlayer contractee) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)contractee);
        LinkedHashSet<ManasSkill> toForget = new LinkedHashSet<ManasSkill>();
        for (Supplier<?> supplier : ALL_SKILLS) {
            toForget.add((ManasSkill)supplier.get());
        }
        toForget.add((ManasSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.WATER_MANIPULATION.get());
        toForget.add((ManasSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.FLAME_MANIPULATION.get());
        toForget.add((ManasSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.WIND_MANIPULATION.get());
        toForget.add((ManasSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.SPATIAL_MANIPULATION.get());
        toForget.add((ManasSkill)com.github.manasmods.tensura.registry.skill.ExtraSkills.EARTH_MANIPULATION.get());
        toForget.add((ManasSkill)ExtraSkills.LIGHT_MANIPULATION.get());
        toForget.add((ManasSkill)ExtraSkills.DARKNESS_MANIPULATION.get());
        for (List list : TABLE.values()) {
            for (List tierList : list) {
                for (Supplier s : tierList) {
                    toForget.add((ManasSkill)s.get());
                }
            }
        }
        for (ManasSkill manasSkill : toForget) {
            if (!storage.getSkill(manasSkill).isPresent()) continue;
            storage.forgetSkill(manasSkill);
        }
        for (ManasSkillInstance manasSkillInstance : storage.getLearnedSkills()) {
            ResistSkill resistance;
            ManasSkill manasSkill = manasSkillInstance.getSkill();
            if (!(manasSkill instanceof ResistSkill) || !((resistance = (ResistSkill)manasSkill) instanceof DarknessAttackResistance) && !(resistance instanceof WaterAttackResistance) && !(resistance instanceof FireAttackResistance) && !(resistance instanceof WindAttackResistance) && !(resistance instanceof SpatialAttackResistance) && !(resistance instanceof EarthAttackResistance) && !(resistance instanceof LightAttackResistance)) continue;
            manasSkillInstance.setMastery(-resistance.pointRequirement());
        }
        storage.syncAll();
    }

    static {
        List<RegistryObject> FLAME_1 = List.of(SpiritualMagics.FIRE);
        List<RegistryObject> FLAME_2 = List.of(SpiritualMagics.FIRE, SpiritualMagics.FIRE_BOLT, SpiritualMagics.FIRE_BREATH);
        List<RegistryObject> FLAME_3 = List.of(SpiritualMagics.FIRE, SpiritualMagics.FIRE_BOLT, SpiritualMagics.FIRE_BREATH, SpiritualMagics.FLARE_CIRCLE, SpiritualMagics.HELLFIRE);
        List<RegistryObject> WIND_1 = List.of(SpiritualMagics.WIND);
        List<RegistryObject> WIND_2 = List.of(SpiritualMagics.WIND, SpiritualMagics.WIND_BLADE, SpiritualMagics.LIGHTNING_LANCE);
        List<RegistryObject> WIND_3 = List.of(SpiritualMagics.WIND, SpiritualMagics.WIND_BLADE, SpiritualMagics.LIGHTNING_LANCE, SpiritualMagics.AERIAL_BLADE, SpiritualMagics.ELECTRO_BLAST);
        List<RegistryObject> EARTH_1 = List.of(SpiritualMagics.EARTH);
        List<RegistryObject> EARTH_2 = List.of(SpiritualMagics.EARTH, SpiritualMagics.EARTH_SPIKES, SpiritualMagics.EARTH_STORM);
        List<RegistryObject> EARTH_3 = List.of(SpiritualMagics.EARTH, SpiritualMagics.EARTH_SPIKES, SpiritualMagics.EARTH_STORM, SpiritualMagics.EARTH_JAIL, SpiritualMagics.MAGMA_SURGE);
        List<RegistryObject> LIGHT_1 = List.of(SpiritualMagics.LIGHT);
        List<RegistryObject> LIGHT_2 = List.of(SpiritualMagics.LIGHT, SpiritualMagics.SOLAR_BEAM, SpiritualMagics.SOLAR_WAVE);
        List<RegistryObject> LIGHT_3 = List.of(SpiritualMagics.LIGHT, SpiritualMagics.SOLAR_BEAM, SpiritualMagics.SOLAR_WAVE, SpiritualMagics.SOLAR_FLARE, SpiritualMagics.SOLAR_RAIN);
        List<RegistryObject> SPACE_1 = List.of(SpiritualMagics.SPACE);
        List<RegistryObject> SPACE_2 = List.of(SpiritualMagics.SPACE, SpiritualMagics.SHRINK, SpiritualMagics.TELEPORT, SpiritualMagics.GATE);
        List<RegistryObject> SPACE_3 = List.of(SpiritualMagics.SPACE, SpiritualMagics.SHRINK, SpiritualMagics.TELEPORT, SpiritualMagics.GATE, SpiritualMagics.SWIPE);
        List<RegistryObject<SpatialVoidMagic>> SPACE_4 = List.of(SpiritualMagics.SPACE, SpiritualMagics.SHRINK, SpiritualMagics.TELEPORT, SpiritualMagics.GATE, SpiritualMagics.SWIPE, MysticismSpiritualMagics.SPATIAL_VOID);
        List<RegistryObject> WATER_1 = List.of(SpiritualMagics.WATER);
        List<RegistryObject> WATER_2 = List.of(SpiritualMagics.WATER, SpiritualMagics.WATER_CUTTER, SpiritualMagics.ACID_RAIN);
        List<RegistryObject> WATER_3 = List.of(SpiritualMagics.WATER, SpiritualMagics.WATER_CUTTER, SpiritualMagics.ACID_RAIN, SpiritualMagics.BLIZZARD, SpiritualMagics.MEGIDDO);
        List<RegistryObject> DARK_1 = List.of(SpiritualMagics.DARKNESS);
        List<RegistryObject> DARK_2 = List.of(SpiritualMagics.DARKNESS, SpiritualMagics.DARK_CUBE, SpiritualMagics.SHADOW_BIND);
        List<RegistryObject> DARK_3 = List.of(SpiritualMagics.DARKNESS, SpiritualMagics.DARK_CUBE, SpiritualMagics.SHADOW_BIND, SpiritualMagics.TRUE_DARKNESS, SpiritualMagics.DARKNESS_CANNON);
        TABLE.put(MagicElemental.FLAME, List.of(FLAME_1, FLAME_2, FLAME_3));
        TABLE.put(MagicElemental.WIND, List.of(WIND_1, WIND_2, WIND_3));
        TABLE.put(MagicElemental.EARTH, List.of(EARTH_1, EARTH_2, EARTH_3));
        TABLE.put(MagicElemental.LIGHT, List.of(LIGHT_1, LIGHT_2, LIGHT_3));
        TABLE.put(MagicElemental.SPACE, List.of(SPACE_1, SPACE_2, SPACE_3, SPACE_4));
        TABLE.put(MagicElemental.WATER, List.of(WATER_1, WATER_2, WATER_3));
        TABLE.put(MagicElemental.DARKNESS, List.of(DARK_1, DARK_2, DARK_3));
    }
}

