/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TimerUtils {
    private static final Map<String, Timer> timers = new HashMap<String, Timer>();
    private static final Map<String, RepeatingTimer> repeatingTimers = new HashMap<String, RepeatingTimer>();

    public static RepeatingTimer getOrCreateRepeatingTimer(String name) {
        return repeatingTimers.computeIfAbsent(name, RepeatingTimer::new);
    }

    public static Timer getOrCreateTimer(String timerName) {
        return timers.computeIfAbsent(timerName, k -> new Timer(timerName));
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (Timer timer : timers.values()) {
                timer.update();
            }
            for (RepeatingTimer repeatingTimer : repeatingTimers.values()) {
                repeatingTimer.update();
            }
        }
    }

    public static class RepeatingTimer {
        private final String name;
        private int ticksElapsed;
        private int maxTicks;
        private Runnable everyTickAction;
        private Runnable onComplete;
        private boolean active;

        public RepeatingTimer(String name) {
            this.name = name;
            this.active = false;
        }

        public void start(int durationTicks, Runnable everyTickAction, Runnable onComplete) {
            this.maxTicks = durationTicks;
            this.everyTickAction = everyTickAction;
            this.onComplete = onComplete;
            this.ticksElapsed = 0;
            this.active = true;
        }

        public void update() {
            if (!this.active) {
                return;
            }
            if (this.everyTickAction != null) {
                this.everyTickAction.run();
                System.out.println("Recording frame for player.");
            }
            ++this.ticksElapsed;
            if (this.ticksElapsed >= this.maxTicks) {
                if (this.onComplete != null) {
                    this.onComplete.run();
                }
                this.stop();
            }
        }

        public void stop() {
            this.active = false;
        }

        public void reset() {
            this.ticksElapsed = 0;
        }

        public boolean isActive() {
            return this.active;
        }
    }

    public static class Timer {
        private final String name;
        private int ticksElapsed;
        private int intervalTicks;
        private boolean active;
        private Runnable action;

        public Timer(String name) {
            this.name = name;
            this.ticksElapsed = 0;
            this.intervalTicks = 60;
            this.active = false;
        }

        public void start(int intervalTicks, Runnable action) {
            this.intervalTicks = intervalTicks;
            this.ticksElapsed = 0;
            this.active = true;
            this.action = action;
        }

        public void reset() {
            this.ticksElapsed = 0;
        }

        public void stop() {
            this.active = false;
        }

        public void update() {
            if (this.active) {
                ++this.ticksElapsed;
                if (this.ticksElapsed >= this.intervalTicks) {
                    if (this.action != null) {
                        this.action.run();
                    }
                    this.reset();
                }
            }
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

