/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.util;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import io.github.Memoires.trmysticism.config.MysticismSkillsConfig;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class UltimateUtils {
    public static final Map<TensuraSkill, TensuraSkill> skillPredecessors = new HashMap<TensuraSkill, TensuraSkill>();

    public static boolean ultimateEvolution(Player entity, List<TensuraSkill> skills) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        for (TensuraSkill skill : skills) {
            Optional instance = storage.getSkill((ManasSkill)skill);
            if (instance.isEmpty()) {
                return false;
            }
            if (((ManasSkillInstance)instance.get()).isMastered((LivingEntity)entity)) continue;
            return false;
        }
        return TensuraPlayerCapability.isTrueDemonLord((Player)entity) || TensuraPlayerCapability.isTrueHero((LivingEntity)entity);
    }

    public static boolean insideConfig(ResourceLocation resourceLocation) {
        List<? extends String> allowedUltimates = MysticismSkillsConfig.getAllowedUltimates();
        return allowedUltimates.contains(resourceLocation.toString());
    }

    public static boolean obtainableUltimates(ResourceLocation resourceLocation) {
        List<? extends String> obtainableUltimates = MysticismSkillsConfig.getObtainableUltimates();
        return obtainableUltimates.contains(resourceLocation.toString());
    }

    private static TensuraSkill getSuccessor(TensuraSkill skill) {
        return skillPredecessors.get(skill);
    }

    public static void handleSkillUpgradeOnAwakening(Player player, SkillStorage skillStorage) {
        for (Map.Entry<TensuraSkill, TensuraSkill> entry : skillPredecessors.entrySet()) {
            TensuraSkill currentSkill = entry.getKey();
            TensuraSkill upgradedSkill = entry.getValue();
            if (player.m_9236_().m_46469_().m_46207_(MysticismGamerules.SOUL_QUALITY_MODE)) {
                int soulQuality = player.getPersistentData().m_128451_("soulQuality");
                int currentUltimates = player.getPersistentData().m_128451_("currentUltimates");
                if (currentUltimates >= soulQuality) {
                    return;
                }
            }
            if (!player.m_9236_().m_46469_().m_46207_(MysticismGamerules.ENABLE_ULTIMATE_SKILL_ACQUISITION)) {
                return;
            }
            if (SkillUtils.hasSkill((Entity)player, (ManasSkill)upgradedSkill) || !SkillUtils.isSkillMastered((LivingEntity)player, (ManasSkill)currentSkill) || !SkillUtils.hasSkill((Entity)player, (ManasSkill)currentSkill) || !skillStorage.learnSkill((ManasSkill)upgradedSkill) || !player.m_9236_().m_46469_().m_46207_(MysticismGamerules.LOSE_UNIQUE_ON_UPGRADE)) continue;
            skillStorage.forgetSkill((ManasSkill)currentSkill);
            player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.ultimate_upgrade", (Object[])new Object[]{currentSkill.getName(), upgradedSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
        }
    }

    static {
        skillPredecessors.put((TensuraSkill)UniqueSkills.ENGORGER.get(), (TensuraSkill)UltimateSkills.ADEPHAGA.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.COMMANDER.get(), (TensuraSkill)UltimateSkills.AMATERASU.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.OPPRESSOR.get(), (TensuraSkill)UltimateSkills.ANTAEUS.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.SEER.get(), (TensuraSkill)UltimateSkills.ANTEVORTA.get());
        skillPredecessors.put((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.INVERSE.get(), (TensuraSkill)UltimateSkills.ANTITHESIS.get());
        skillPredecessors.put((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.CAPTIVATOR.get(), (TensuraSkill)UltimateSkills.AME_NO_UZUME.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.MUSICIAN.get(), (TensuraSkill)UltimateSkills.APOLLO.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.GOURMET.get(), (TensuraSkill)UltimateSkills.BEELZEBUB.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.SLOTH.get(), (TensuraSkill)UltimateSkills.BELPHEGOR.get());
        skillPredecessors.put((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.STAGNATOR.get(), (TensuraSkill)UltimateSkills.BUSHYASTA.get());
        skillPredecessors.put((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.CRASHER.get(), (TensuraSkill)UltimateSkills.DIONYSUS.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.OBSERVER.get(), (TensuraSkill)UltimateSkills.GALILEO.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.REAPER.get(), (TensuraSkill)UltimateSkills.HADES.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.SNIPER.get(), (TensuraSkill)UltimateSkills.HERACLES.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.FUSIONIST.get(), (TensuraSkill)UltimateSkills.IGNIS.get());
        skillPredecessors.put((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.VICTORIOUS_HARBINGER.get(), (TensuraSkill)UltimateSkills.INVICTUS.get());
        skillPredecessors.put((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.VAINGLORY.get(), (TensuraSkill)UltimateSkills.LAVERNA.get());
        skillPredecessors.put((TensuraSkill)UltimateSkills.SEPHIROT.get(), (TensuraSkill)UltimateSkills.MEPHISTO.get());
        skillPredecessors.put((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.MELANCHOLY.get(), (TensuraSkill)UltimateSkills.OIZYS.get());
        skillPredecessors.put((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.COMPULSOR.get(), (TensuraSkill)UltimateSkills.PERNIDA.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.MURDERER.get(), (TensuraSkill)UltimateSkills.SANDALPHON.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.UNYIELDING.get(), (TensuraSkill)UltimateSkills.SARIEL.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.WRATH.get(), (TensuraSkill)UltimateSkills.SATANAEL.get());
        skillPredecessors.put((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.DREAMER.get(), (TensuraSkill)UltimateSkills.SEPHIROT.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.COOK.get(), (TensuraSkill)UltimateSkills.SUSANOO.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.MARTIAL_MASTER.get(), (TensuraSkill)UltimateSkills.TAKEMIKAZUCHI.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.SHADOW_STRIKER.get(), (TensuraSkill)UltimateSkills.TSUKUYOMI.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.INFINITY_PRISON.get(), (TensuraSkill)UltimateSkills.URIEL.get());
        skillPredecessors.put((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.HIDDEN_RULER.get(), (TensuraSkill)UltimateSkills.VICIEL.get());
        skillPredecessors.put((TensuraSkill)UniqueSkills.FALSIFIER.get(), (TensuraSkill)UltimateSkills.XEZBETH.get());
        skillPredecessors.put((TensuraSkill)io.github.Memoires.trmysticism.registry.skill.UniqueSkills.GATEKEEPER.get(), (TensuraSkill)UltimateSkills.GILGAMESH.get());
    }
}

