/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.world;

import com.github.manasmods.tensura.ability.magic.MagicElemental;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class ContractLedger
extends SavedData {
    private final Int2ObjectMap<Entry> byId = new Int2ObjectOpenHashMap();

    public static ContractLedger get(ServerLevel level) {
        return (ContractLedger)level.m_7654_().m_129783_().m_8895_().m_164861_(nbt -> {
            ContractLedger d = new ContractLedger();
            ListTag list = nbt.m_128437_("entries", 10);
            for (int i = 0; i < list.size(); ++i) {
                Entry e = Entry.load(list.m_128728_(i));
                d.byId.put(e.id, (Object)e);
            }
            return d;
        }, () -> new ContractLedger(), "trmysticism_contract_ledger");
    }

    public void upsert(Entry e) {
        this.byId.put(e.id, (Object)e);
        this.m_77762_();
    }

    public void setStatus(int id, Status status) {
        Entry e = (Entry)this.byId.get(id);
        if (e != null) {
            e.status = status;
            e.updatedAt = System.currentTimeMillis();
            this.m_77762_();
        }
    }

    public List<Entry> allFor(UUID player) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        this.byId.values().forEach(e -> {
            if (player.equals(e.contractor) || player.equals(e.contractee)) {
                list.add((Entry)e);
            }
        });
        return list;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        this.byId.values().forEach(e -> list.add((Object)e.save()));
        nbt.m_128365_("entries", (Tag)list);
        return nbt;
    }

    public static class Entry {
        public int id;
        public UUID contractor;
        public UUID contractee;
        public MagicElemental element;
        public Status status;
        public long updatedAt;

        public CompoundTag save() {
            CompoundTag t = new CompoundTag();
            t.m_128405_("id", this.id);
            t.m_128362_("contractor", this.contractor);
            t.m_128362_("contractee", this.contractee);
            t.m_128359_("element", this.element.name());
            t.m_128359_("status", this.status.name());
            t.m_128356_("updatedAt", this.updatedAt);
            return t;
        }

        public static Entry load(CompoundTag t) {
            Entry e = new Entry();
            e.id = t.m_128451_("id");
            e.contractor = t.m_128342_("contractor");
            e.contractee = t.m_128342_("contractee");
            e.element = MagicElemental.valueOf((String)t.m_128461_("element"));
            e.status = Status.valueOf(t.m_128461_("status"));
            e.updatedAt = t.m_128454_("updatedAt");
            return e;
        }
    }

    public static enum Status {
        PENDING,
        ACTIVE,
        DISSOLVED;

    }
}

