/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.world.features;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ErodedRockMoundFeature
extends Feature<NoneFeatureConfiguration> {
    private final List<BlockState> BLOCKS = ImmutableList.of((Object)Blocks.f_49993_.m_49966_(), (Object)Blocks.f_50352_.m_49966_(), (Object)Blocks.f_50288_.m_49966_(), (Object)Blocks.f_50069_.m_49966_());

    public ErodedRockMoundFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos origin = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        while (origin.m_123342_() > level.m_141937_() + 3 && (level.m_46859_(origin.m_7495_()) || !this.isValidBase(level, origin.m_7495_()))) {
            origin = origin.m_7495_();
        }
        if (origin.m_123342_() <= level.m_141937_() + 3) {
            return false;
        }
        int radius = 3 + random.m_188503_(5);
        int height = 2 + random.m_188503_(3);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                double distance = Math.sqrt(dx * dx + dz * dz);
                if (!(distance <= (double)radius + 0.5)) continue;
                int columnHeight = (int)((double)height * (1.0 - distance / (double)radius) + random.m_188500_());
                for (int dy = 0; dy <= columnHeight; ++dy) {
                    mutable.m_122178_(origin.m_123341_() + dx, origin.m_123342_() + dy, origin.m_123343_() + dz);
                    BlockState chosen = this.BLOCKS.get(random.m_188503_(this.BLOCKS.size()));
                    level.m_7731_((BlockPos)mutable, chosen, 2);
                }
            }
        }
        return true;
    }

    private boolean isValidBase(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60713_(Blocks.f_49992_) || state.m_60713_(Blocks.f_49993_) || state.m_60713_(Blocks.f_50352_);
    }
}

