/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.doubleedge.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.pigling.doubleedge.DoubleedgeMod;
import net.pigling.doubleedge.procedures.CrafterInitOutputProcedure;
import net.pigling.doubleedge.procedures.CrafterInputProcedure;
import net.pigling.doubleedge.procedures.CrafterOutputProcedure;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SplitterMenuSlotMessage {
    private final int slotID;
    private final int x;
    private final int y;
    private final int z;
    private final int changeType;
    private final int meta;

    public SplitterMenuSlotMessage(int slotID, int x, int y, int z, int changeType, int meta) {
        this.slotID = slotID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.changeType = changeType;
        this.meta = meta;
    }

    public SplitterMenuSlotMessage(FriendlyByteBuf buffer) {
        this.slotID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.changeType = buffer.readInt();
        this.meta = buffer.readInt();
    }

    public static void buffer(SplitterMenuSlotMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }

    public static void handler(SplitterMenuSlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SplitterMenuSlotMessage.handleSlotAction((Player)context.getSender(), message.slotID, message.changeType, message.meta, message.x, message.y, message.z));
        context.setPacketHandled(true);
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        int amount;
        Level world = entity.f_19853_;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 0 && changeType == 0) {
            CrafterInputProcedure.execute((Entity)entity);
        }
        if (slot == 0 && changeType == 1) {
            amount = meta;
            CrafterInitOutputProcedure.execute((Entity)entity);
        }
        if (slot == 0 && changeType == 2) {
            amount = meta;
            CrafterInitOutputProcedure.execute((Entity)entity);
        }
        if (slot == 1 && changeType == 1) {
            amount = meta;
            CrafterOutputProcedure.execute((Entity)entity);
        }
        if (slot == 1 && changeType == 2) {
            amount = meta;
            CrafterOutputProcedure.execute((Entity)entity);
        }
        if (slot == 2 && changeType == 1) {
            amount = meta;
            CrafterOutputProcedure.execute((Entity)entity);
        }
        if (slot == 2 && changeType == 2) {
            amount = meta;
            CrafterOutputProcedure.execute((Entity)entity);
        }
        if (slot == 3 && changeType == 0) {
            CrafterInputProcedure.execute((Entity)entity);
        }
        if (slot == 3 && changeType == 1) {
            amount = meta;
            CrafterInitOutputProcedure.execute((Entity)entity);
        }
        if (slot == 3 && changeType == 2) {
            amount = meta;
            CrafterInitOutputProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DoubleedgeMod.addNetworkMessage(SplitterMenuSlotMessage.class, SplitterMenuSlotMessage::buffer, SplitterMenuSlotMessage::new, SplitterMenuSlotMessage::handler);
    }
}

