/*
 * Decompiled with CFR 0.152.
 */
package net.pigling.doubleedge.init;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.pigling.doubleedge.DoubleedgeMod;
import net.pigling.doubleedge.init.DoubleedgeModScreens;
import net.pigling.doubleedge.network.MenuStateUpdateMessage;
import net.pigling.doubleedge.world.inventory.NetherFurnaceMenuMenu;
import net.pigling.doubleedge.world.inventory.SplitterMenuMenu;

public class DoubleedgeModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"doubleedge");
    public static final RegistryObject<MenuType<SplitterMenuMenu>> SPLITTER_MENU = REGISTRY.register("splitter_menu", () -> IForgeMenuType.create(SplitterMenuMenu::new));
    public static final RegistryObject<MenuType<NetherFurnaceMenuMenu>> NETHER_FURNACE_MENU = REGISTRY.register("nether_furnace_menu", () -> IForgeMenuType.create(NetherFurnaceMenuMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                DoubleedgeMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.f_19853_.f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof DoubleedgeModScreens.ScreenAccessor) {
                    DoubleedgeModScreens.ScreenAccessor accessor = (DoubleedgeModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                DoubleedgeMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

