/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.compat.waila;

import dev.kvnmtz.createmobspawners.CreateMobSpawners;
import dev.kvnmtz.createmobspawners.block.custom.entity.MechanicalSpawnerBlockEntity;
import dev.kvnmtz.createmobspawners.capabilities.entitystorage.StoredEntityData;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;

public enum MechanicalSpawnerComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>,
IServerExtensionProvider<MechanicalSpawnerBlockEntity, CompoundTag>,
IClientExtensionProvider<CompoundTag, FluidView>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Optional<String> optEntityDisplayName;
        MechanicalSpawnerBlockEntity spawner = (MechanicalSpawnerBlockEntity)accessor.getBlockEntity();
        StoredEntityData entityData = spawner.getStoredEntityData();
        if (!entityData.isEmpty() && (optEntityDisplayName = entityData.getEntityDisplayName()).isPresent()) {
            MutableComponent title = accessor.getBlock().m_49954_();
            title = Component.m_237110_((String)"create_mob_spawners.waila.spawner_title", (Object[])new Object[]{title, optEntityDisplayName.get()});
            tooltip.remove(Identifiers.CORE_OBJECT_NAME);
            tooltip.add(0, (Component)IThemeHelper.get().title((Object)title), Identifiers.CORE_OBJECT_NAME);
            CompoundTag serverData = accessor.getServerData();
            if (serverData.m_128441_("StallingReason")) {
                tooltip.add((Component)Component.m_237115_((String)("create_mob_spawners.waila.spawner_stalling_reason." + serverData.m_128461_("StallingReason"))).m_130940_(ChatFormatting.RED));
            } else if (serverData.m_128441_("Progress")) {
                tooltip.add((Component)Component.m_237110_((String)"create_mob_spawners.waila.spawner_progress", (Object[])new Object[]{IThemeHelper.get().info((Object)String.format("%d%%", serverData.m_128451_("Progress")))}));
            } else if (serverData.m_128441_("DelayReason")) {
                tooltip.add((Component)Component.m_237110_((String)"create_mob_spawners.waila.spawner_progress", (Object[])new Object[]{IThemeHelper.get().warning((Object)Component.m_237115_((String)"create_mob_spawners.waila.spawner_progress.delaying"))}));
                tooltip.add((Component)Component.m_237110_((String)"create_mob_spawners.waila.spawner_progress.delay_reason", (Object[])new Object[]{IThemeHelper.get().info((Object)Component.m_237115_((String)serverData.m_128461_("DelayReason")))}));
            }
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"create_mob_spawners.waila.spawner_stalling_reason.no_soul").m_130940_(ChatFormatting.RED));
    }

    public ResourceLocation getUid() {
        return CreateMobSpawners.asResource("spawner_progress");
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        MechanicalSpawnerBlockEntity spawner = (MechanicalSpawnerBlockEntity)accessor.getBlockEntity();
        Optional<String> optStallingReasonKey = spawner.getStallingReasonTranslationKey();
        if (optStallingReasonKey.isPresent()) {
            data.m_128359_("StallingReason", optStallingReasonKey.get());
        } else if (spawner.isDelayed()) {
            data.m_128359_("DelayReason", spawner.getDelayReasonTranslationKey());
        } else {
            data.m_128405_("Progress", spawner.getSpawnProgressPercentage());
        }
    }

    public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> groups) {
        return ClientViewGroup.map(groups, FluidView::readDefault, null);
    }

    @NotNull
    public List<ViewGroup<CompoundTag>> getGroups(ServerPlayer player, ServerLevel world, MechanicalSpawnerBlockEntity blockEntity, boolean showDetails) {
        FluidStack fluidStack = blockEntity.getFluidStack();
        ViewGroup tank = new ViewGroup(List.of(FluidView.writeDefault((JadeFluidObject)JadeFluidObject.of((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount(), (CompoundTag)fluidStack.getTag()), (long)blockEntity.getTank().getPrimaryHandler().getCapacity())));
        return List.of(tank);
    }
}

