/*
 * Decompiled with CFR 0.152.
 */
package dev.kvnmtz.createmobspawners.gui.screens;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.TooltipArea;
import dev.kvnmtz.createmobspawners.CreateMobSpawners;
import dev.kvnmtz.createmobspawners.block.custom.entity.MechanicalSpawnerBlockEntity;
import dev.kvnmtz.createmobspawners.block.registry.ModBlocks;
import dev.kvnmtz.createmobspawners.gui.registry.ModGuiTextures;
import dev.kvnmtz.createmobspawners.network.PacketHandler;
import dev.kvnmtz.createmobspawners.network.packet.ServerboundConfigureSpawnerPacket;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SpawnerScreen
extends AbstractSimiScreen {
    private final ItemStack renderedItem = new ItemStack((ItemLike)ModBlocks.MECHANICAL_SPAWNER.get());
    private final ModGuiTextures background;
    private final MechanicalSpawnerBlockEntity blockEntity;
    private final List<ScrollInput> spawnAreaInputs = new ArrayList<ScrollInput>();

    public SpawnerScreen(MechanicalSpawnerBlockEntity be) {
        super((Component)Component.m_237115_((String)"block.create_mob_spawners.mechanical_spawner"));
        this.background = ModGuiTextures.SPAWNER;
        this.blockEntity = be;
    }

    protected void renderWindow(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        graphics.m_280614_(this.f_96547_, this.f_96539_, x + (this.background.width - 8) / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, y + 4, 5841956, false);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)this.renderedItem).at((float)(x + this.background.width + 6), (float)(y + this.background.height - 56), -200.0f)).scale(5.0).render(graphics);
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-20, 0);
        super.m_7856_();
        this.blockEntity.stopLingerSpawnAreaHighlighting();
        int x = this.guiLeft;
        int y = this.guiTop;
        String spawnerGuiKeyPrefix = "create_mob_spawners.gui.spawner.";
        TooltipArea spawnAreaTooltip = new TooltipArea(x + 49, y + 23, 18, 18).withTooltip(List.of(Component.m_237115_((String)"create_mob_spawners.gui.spawner.spawning_area")));
        this.m_142416_((GuiEventListener)spawnAreaTooltip);
        List<MutableComponent> titles = List.of(Component.m_237115_((String)"create_mob_spawners.gui.spawner.width"), Component.m_237115_((String)"create_mob_spawners.gui.spawner.height"), Component.m_237115_((String)"create_mob_spawners.gui.spawner.height_offset"));
        List<Pair> ranges = List.of(Pair.of((Object)((Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMinWidth.get()), (Object)((Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMaxWidth.get())), Pair.of((Object)((Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMinHeight.get()), (Object)((Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMaxHeight.get())), Pair.of((Object)((Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMinHeightOffset.get()), (Object)((Integer)CreateMobSpawners.SERVER_CONFIG.mechanicalSpawnerAreaMaxHeightOffset.get())));
        for (int i = 0; i < 3; ++i) {
            Label label = new Label(x + 82 + i * 20, y + 28, CommonComponents.f_237098_).withShadow();
            int finalIdx = i;
            ScrollInput input = new ScrollInput(x + 73 + i * 20, y + 23, 18, 18).withRange(((Integer)ranges.get(i).getFirst()).intValue(), (Integer)ranges.get(i).getSecond() + 1).writingTo(label).titled(titles.get(i)).calling(value -> label.m_252865_(x + 82 + finalIdx * 20 - this.f_96547_.m_92852_((FormattedText)label.text) / 2)).withStepFunction(stepContext -> {
                if (finalIdx == 2) {
                    return 1;
                }
                return 2;
            });
            switch (finalIdx) {
                case 0: {
                    input.setState(this.blockEntity.getSpawningAreaWidth());
                    break;
                }
                case 1: {
                    input.setState(this.blockEntity.getSpawningAreaHeight());
                    break;
                }
                case 2: {
                    input.setState(this.blockEntity.getSpawningAreaHeightOffset());
                }
            }
            input.onChanged();
            this.m_142416_((GuiEventListener)label);
            this.m_142416_((GuiEventListener)input);
            this.spawnAreaInputs.add(input);
        }
        IconButton confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> ((SpawnerScreen)this).m_7379_());
        this.m_142416_((GuiEventListener)confirmButton);
    }

    public void m_86600_() {
        super.m_86600_();
        this.blockEntity.highlightSpawningArea(this.spawnAreaInputs.get(0).getState(), this.spawnAreaInputs.get(1).getState(), this.spawnAreaInputs.get(2).getState());
    }

    public void m_7861_() {
        super.m_7861_();
        this.send();
        this.blockEntity.lingerSpawnAreaHighlighting(this.spawnAreaInputs.get(0).getState(), this.spawnAreaInputs.get(1).getState(), this.spawnAreaInputs.get(2).getState());
    }

    private void send() {
        PacketHandler.sendToServer((Object)new ServerboundConfigureSpawnerPacket(this.blockEntity.m_58899_(), this.spawnAreaInputs.get(0).getState(), this.spawnAreaInputs.get(1).getState(), this.spawnAreaInputs.get(2).getState()));
    }
}

