/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.crafting;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crafting.INighttimeRecipe;
import hellfirepvp.astralsorcery.common.crafting.ISpecialCraftingEffects;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemTunedCrystalBase;
import hellfirepvp.astralsorcery.common.item.useables.ItemUsableDust;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedastral.item.ItemConstellationFocus;

public class RecipeConstellationFocus
extends TraitRecipe
implements INighttimeRecipe,
ISpecialCraftingEffects {
    public static final RecipeConstellationFocus INSTANCE = new RecipeConstellationFocus();
    private static Vector3[] offsetPillarsT2 = new Vector3[]{new Vector3(3, 2, 3), new Vector3(-3, 2, 3), new Vector3(3, 2, -3), new Vector3(-3, 2, -3)};
    private static Vector3[] offsetPillarsT3 = new Vector3[]{new Vector3(4, 3, 4), new Vector3(-4, 3, 4), new Vector3(4, 3, -4), new Vector3(-4, 3, -4)};

    protected RecipeConstellationFocus() {
        super((AccessibleRecipe)RecipeConstellationFocus.shapedRecipe((String)"packagedastral/constellation_focus", (Item)ItemConstellationFocus.INSTANCE).addPart((Item)ItemsAS.shiftingStar, new ShapedRecipeSlot[]{ShapedRecipeSlot.CENTER}).addPart("paneGlassColorless", new ShapedRecipeSlot[]{ShapedRecipeSlot.UPPER_LEFT, ShapedRecipeSlot.UPPER_RIGHT, ShapedRecipeSlot.LOWER_LEFT, ShapedRecipeSlot.LOWER_RIGHT}).addPart(ItemCraftingComponent.MetaType.GLASS_LENS.asStack(), new ShapedRecipeSlot[]{ShapedRecipeSlot.UPPER_CENTER, ShapedRecipeSlot.LEFT, ShapedRecipeSlot.RIGHT, ShapedRecipeSlot.LOWER_CENTER}).unregisteredAccessibleShapedRecipe());
        this.setCstItem(this.getTunedCrystal((IWeakConstellation)Constellations.discidia), new ConstellationRecipe.ConstellationAtlarSlot[]{ConstellationRecipe.ConstellationAtlarSlot.UP_UP_RIGHT});
        this.setInnerTraitItem(this.getTunedCrystal((IWeakConstellation)Constellations.armara), new TraitRecipe.TraitRecipeSlot[]{TraitRecipe.TraitRecipeSlot.RIGHT_CENTER});
        this.setInnerTraitItem(this.getTunedCrystal((IWeakConstellation)Constellations.vicio), new TraitRecipe.TraitRecipeSlot[]{TraitRecipe.TraitRecipeSlot.LOWER_CENTER});
        this.setInnerTraitItem(this.getTunedCrystal((IWeakConstellation)Constellations.aevitas), new TraitRecipe.TraitRecipeSlot[]{TraitRecipe.TraitRecipeSlot.LEFT_CENTER});
        this.setCstItem(this.getTunedCrystal((IWeakConstellation)Constellations.evorsio), new ConstellationRecipe.ConstellationAtlarSlot[]{ConstellationRecipe.ConstellationAtlarSlot.UP_UP_LEFT});
        this.setInnerTraitItem(this.getTunedCrystal(Constellations.octans), new TraitRecipe.TraitRecipeSlot[]{TraitRecipe.TraitRecipeSlot.UPPER_CENTER});
        this.setCstItem(this.getTunedCrystal(Constellations.bootes), new ConstellationRecipe.ConstellationAtlarSlot[]{ConstellationRecipe.ConstellationAtlarSlot.UP_RIGHT_RIGHT});
        this.setCstItem(this.getTunedCrystal(Constellations.fornax), new ConstellationRecipe.ConstellationAtlarSlot[]{ConstellationRecipe.ConstellationAtlarSlot.DOWN_RIGHT_RIGHT});
        this.setCstItem(this.getTunedCrystal(Constellations.lucerna), new ConstellationRecipe.ConstellationAtlarSlot[]{ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_RIGHT});
        this.setCstItem(this.getTunedCrystal(Constellations.horologium), new ConstellationRecipe.ConstellationAtlarSlot[]{ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_LEFT});
        this.setCstItem(this.getTunedCrystal(Constellations.mineralis), new ConstellationRecipe.ConstellationAtlarSlot[]{ConstellationRecipe.ConstellationAtlarSlot.DOWN_LEFT_LEFT});
        this.setCstItem(this.getTunedCrystal(Constellations.pelotrio), new ConstellationRecipe.ConstellationAtlarSlot[]{ConstellationRecipe.ConstellationAtlarSlot.UP_LEFT_LEFT});
        this.addOuterTraitItem(ItemUsableDust.DustType.ILLUMINATION.asStack());
        this.addOuterTraitItem("dustAstralStarmetal");
        this.addOuterTraitItem(ItemUsableDust.DustType.ILLUMINATION.asStack());
        this.addOuterTraitItem(ItemUsableDust.DustType.NOCTURNAL.asStack());
        this.addOuterTraitItem(ItemUsableDust.DustType.ILLUMINATION.asStack());
        this.addOuterTraitItem("dustAstralStarmetal");
        this.addOuterTraitItem(ItemUsableDust.DustType.ILLUMINATION.asStack());
        this.addOuterTraitItem(ItemUsableDust.DustType.NOCTURNAL.asStack());
        this.setRequiredConstellation((IConstellation)Constellations.lucerna);
    }

    public ItemHandle getTunedCrystal(IWeakConstellation constellation) {
        ItemStack rock = new ItemStack((Item)ItemsAS.tunedRockCrystal);
        ItemStack celestial = new ItemStack((Item)ItemsAS.tunedCelestialCrystal);
        NBTHelper.getPersistentData((ItemStack)rock).func_74782_a("crystalProperties", (NBTBase)new NBTTagCompound());
        ItemTunedCrystalBase.applyMainConstellation((ItemStack)rock, (IWeakConstellation)constellation);
        NBTHelper.getPersistentData((ItemStack)celestial).func_74782_a("crystalProperties", (NBTBase)new NBTTagCompound());
        ItemTunedCrystalBase.applyMainConstellation((ItemStack)celestial, (IWeakConstellation)constellation);
        return new ItemHandle(new ItemStack[]{rock, celestial});
    }

    public AbstractAltarRecipe copyNewEffectInstance() {
        return new RecipeConstellationFocus();
    }

    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        if (state == ActiveCraftingTask.CraftingState.ACTIVE) {
            Vector3 r = new Vector3((TileEntity)altar).add((double)(rand.nextFloat() * 7.0f - 3.0f), 0.1, (double)(rand.nextFloat() * 7.0f - 3.0f));
            EffectHelper.genericFlareParticle((Vector3)r).scale(0.7f).gravity(0.02);
            if (tick % 50L == 0L) {
                Vector3 vec = new Vector3((TileEntity)altar).add(0.5, 0.5, 0.5);
                switch (altar.getAltarLevel()) {
                    case ATTUNEMENT: {
                        for (Vector3 offset : offsetPillarsT2) {
                            EffectHandler.getInstance().lightbeam(offset.clone().add(vec), vec, 1.2);
                        }
                        break;
                    }
                    case CONSTELLATION_CRAFT: {
                        for (Vector3 offset : offsetPillarsT3) {
                            EffectHandler.getInstance().lightbeam(offset.clone().add(vec), vec, 1.2);
                        }
                        break;
                    }
                }
            }
            if (rand.nextInt(10) == 0) {
                Vector3 from = new Vector3((TileEntity)altar).add(0.5, -0.6, 0.5);
                MiscUtils.applyRandomOffset((Vector3)from, (Random)rand, (float)1.8f);
                from.addY((double)(rand.nextFloat() * 2.0f - 1.0f));
                EffectHandler.getInstance().lightbeam(from.clone().addY((double)(5 + rand.nextInt(3))), from, 1.0).setMaxAge(64);
            }
        }
    }
}

