/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.event;

import hellfirepvp.astralsorcery.common.block.BlockInfusedWood;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.AltarRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipeAdapater;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.item.useables.ItemUsableDust;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.structure.MatchableStructure;
import hellfirepvp.astralsorcery.common.structure.StructureMatcherRegistry;
import hellfirepvp.astralsorcery.common.structure.StructureRegistry;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.structure.match.StructureMatcherPatternArray;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.packagedastral.block.BlockAttunementCrafter;
import thelm.packagedastral.block.BlockConstellationCrafter;
import thelm.packagedastral.block.BlockDiscoveryCrafter;
import thelm.packagedastral.block.BlockMarkedRelay;
import thelm.packagedastral.block.BlockTraitCrafter;
import thelm.packagedastral.config.PackagedAstralConfig;
import thelm.packagedastral.crafting.RecipeAttunementCrafter;
import thelm.packagedastral.crafting.RecipeConstellationCrafter;
import thelm.packagedastral.crafting.RecipeConstellationFocus;
import thelm.packagedastral.crafting.RecipeTraitCrafter;
import thelm.packagedastral.integration.patchouli.PackagedAstralPatchouliHandler;
import thelm.packagedastral.item.ItemConstellationFocus;
import thelm.packagedastral.recipe.RecipeTypeAttunement;
import thelm.packagedastral.recipe.RecipeTypeConstellation;
import thelm.packagedastral.recipe.RecipeTypeDiscovery;
import thelm.packagedastral.recipe.RecipeTypeTrait;
import thelm.packagedastral.structure.StructureAttunementCrafter;
import thelm.packagedastral.structure.StructureConstellationCrafter;
import thelm.packagedastral.structure.StructureMarkedRelay;
import thelm.packagedastral.structure.StructureTraitCrafter;
import thelm.packagedastral.tile.TileAttunementCrafter;
import thelm.packagedastral.tile.TileConstellationCrafter;
import thelm.packagedastral.tile.TileDiscoveryCrafter;
import thelm.packagedastral.tile.TileMarkedRelay;
import thelm.packagedastral.tile.TileTraitCrafter;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.api.RecipeTypeRegistry;
import thelm.packagedauto.item.ItemMisc;

public class CommonEventHandler {
    public void registerBlock(Block block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
    }

    public void registerItem(Item item) {
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    public void registerStructure(PatternBlockArray structure) {
        StructureRegistry.INSTANCE.register((MatchableStructure)structure);
        StructureMatcherRegistry.INSTANCE.register(() -> new StructureMatcherPatternArray(structure.getRegistryName()));
    }

    public void onPreInit(FMLPreInitializationEvent event) {
        this.registerConfig(event);
        this.registerBlocks();
        this.registerItems();
        this.registerTileEntities();
        this.registerRecipeTypes();
    }

    public void onInit(FMLInitializationEvent event) {
        this.registerStructures();
        this.registerRecipes();
        MiscUtil.conditionalRunnable(() -> Loader.isModLoaded((String)"patchouli"), () -> () -> PackagedAstralPatchouliHandler.init(), () -> () -> {}).run();
    }

    protected void registerConfig(FMLPreInitializationEvent event) {
        PackagedAstralConfig.init(event.getSuggestedConfigurationFile());
    }

    protected void registerBlocks() {
        if (TileDiscoveryCrafter.enabled) {
            this.registerBlock((Block)BlockMarkedRelay.INSTANCE);
            this.registerBlock((Block)BlockDiscoveryCrafter.INSTANCE);
        }
        if (TileAttunementCrafter.enabled) {
            this.registerBlock((Block)BlockAttunementCrafter.INSTANCE);
        }
        if (TileConstellationCrafter.enabled) {
            this.registerBlock((Block)BlockConstellationCrafter.INSTANCE);
        }
        if (TileTraitCrafter.enabled) {
            this.registerBlock((Block)BlockTraitCrafter.INSTANCE);
        }
    }

    protected void registerItems() {
        if (TileDiscoveryCrafter.enabled) {
            this.registerItem(BlockMarkedRelay.ITEM_INSTANCE);
            this.registerItem(BlockDiscoveryCrafter.ITEM_INSTANCE);
        }
        if (TileAttunementCrafter.enabled) {
            this.registerItem(BlockAttunementCrafter.ITEM_INSTANCE);
        }
        if (TileConstellationCrafter.enabled) {
            this.registerItem(BlockConstellationCrafter.ITEM_INSTANCE);
        }
        if (TileTraitCrafter.enabled) {
            this.registerItem(BlockTraitCrafter.ITEM_INSTANCE);
            this.registerItem(ItemConstellationFocus.INSTANCE);
        }
    }

    protected void registerTileEntities() {
        if (TileDiscoveryCrafter.enabled) {
            GameRegistry.registerTileEntity(TileMarkedRelay.class, (ResourceLocation)new ResourceLocation("packagedastral:marked_relay"));
            GameRegistry.registerTileEntity(TileDiscoveryCrafter.class, (ResourceLocation)new ResourceLocation("packagedastral:discovery_crafter"));
        }
        if (TileAttunementCrafter.enabled) {
            GameRegistry.registerTileEntity(TileAttunementCrafter.class, (ResourceLocation)new ResourceLocation("packagedastral:attunement_crafter"));
        }
        if (TileConstellationCrafter.enabled) {
            GameRegistry.registerTileEntity(TileConstellationCrafter.class, (ResourceLocation)new ResourceLocation("packagedastral:constellation_crafter"));
        }
        if (TileTraitCrafter.enabled) {
            GameRegistry.registerTileEntity(TileTraitCrafter.class, (ResourceLocation)new ResourceLocation("packagedastral:trait_crafter"));
        }
    }

    protected void registerRecipeTypes() {
        if (TileDiscoveryCrafter.enabled) {
            RecipeTypeRegistry.registerRecipeType((IRecipeType)RecipeTypeDiscovery.INSTANCE);
        }
        if (TileAttunementCrafter.enabled) {
            RecipeTypeRegistry.registerRecipeType((IRecipeType)RecipeTypeAttunement.INSTANCE);
        }
        if (TileConstellationCrafter.enabled) {
            RecipeTypeRegistry.registerRecipeType((IRecipeType)RecipeTypeConstellation.INSTANCE);
        }
        if (TileTraitCrafter.enabled) {
            RecipeTypeRegistry.registerRecipeType((IRecipeType)RecipeTypeTrait.INSTANCE);
        }
    }

    protected void registerStructures() {
        if (TileDiscoveryCrafter.enabled) {
            this.registerStructure(StructureMarkedRelay.INSTANCE);
        }
        if (TileAttunementCrafter.enabled) {
            this.registerStructure(StructureAttunementCrafter.INSTANCE);
        }
        if (TileConstellationCrafter.enabled) {
            this.registerStructure(StructureConstellationCrafter.INSTANCE);
        }
        if (TileTraitCrafter.enabled) {
            this.registerStructure(StructureTraitCrafter.INSTANCE);
        }
    }

    protected void registerRecipes() {
        if (TileDiscoveryCrafter.enabled) {
            AltarRecipeRegistry.registerDiscoveryRecipe((AccessibleRecipeAdapater)ShapedRecipe.Builder.newShapedRecipe((String)"packagedastral/marked_relay", (Item)BlockMarkedRelay.ITEM_INSTANCE).addPart((Block)BlocksAS.attunementRelay, new ShapedRecipeSlot[]{ShapedRecipeSlot.CENTER}).addPart(ItemCraftingComponent.MetaType.GLASS_LENS.asStack(), new ShapedRecipeSlot[]{ShapedRecipeSlot.UPPER_CENTER}).addPart(ItemUsableDust.DustType.ILLUMINATION.asStack(), new ShapedRecipeSlot[]{ShapedRecipeSlot.LEFT, ShapedRecipeSlot.RIGHT, ShapedRecipeSlot.LOWER_CENTER}).unregisteredAccessibleShapedRecipe());
            ItemMisc component = Loader.isModLoaded((String)"appliedenergistics2") ? ItemMisc.ME_PACKAGE_COMPONENT : ItemMisc.PACKAGE_COMPONENT;
            AltarRecipeRegistry.registerDiscoveryRecipe((AccessibleRecipeAdapater)ShapedRecipe.Builder.newShapedRecipe((String)"packagedastral/discovery_crafter", (Block)BlockDiscoveryCrafter.INSTANCE).addPart(new ItemStack((Block)BlocksAS.blockAltar, 1, 0), new ShapedRecipeSlot[]{ShapedRecipeSlot.CENTER}).addPart((Item)ItemsAS.wand, new ShapedRecipeSlot[]{ShapedRecipeSlot.UPPER_CENTER}).addPart((Item)component, new ShapedRecipeSlot[]{ShapedRecipeSlot.LOWER_CENTER}).addPart(BlockInfusedWood.WoodType.RAW.asStack(), new ShapedRecipeSlot[]{ShapedRecipeSlot.LEFT, ShapedRecipeSlot.RIGHT}).addPart(BlockMarble.MarbleBlockType.CHISELED.asStack(), new ShapedRecipeSlot[]{ShapedRecipeSlot.UPPER_LEFT, ShapedRecipeSlot.UPPER_RIGHT, ShapedRecipeSlot.LOWER_LEFT, ShapedRecipeSlot.LOWER_RIGHT}).unregisteredAccessibleShapedRecipe());
        }
        if (TileAttunementCrafter.enabled) {
            AltarRecipeRegistry.registerAltarRecipe((AbstractAltarRecipe)RecipeAttunementCrafter.INSTANCE);
        }
        if (TileConstellationCrafter.enabled) {
            AltarRecipeRegistry.registerAltarRecipe((AbstractAltarRecipe)RecipeConstellationCrafter.INSTANCE);
        }
        if (TileTraitCrafter.enabled) {
            AltarRecipeRegistry.registerAltarRecipe((AbstractAltarRecipe)RecipeTraitCrafter.INSTANCE);
            AltarRecipeRegistry.registerAltarRecipe((AbstractAltarRecipe)RecipeConstellationFocus.INSTANCE);
        }
    }
}

