/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.integration.patchouli;

import hellfirepvp.astralsorcery.common.structure.array.BlockArray;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import it.unimi.dsi.fastutil.objects.Object2CharLinkedOpenHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import thelm.packagedastral.structure.StructureAttunementCrafter;
import thelm.packagedastral.structure.StructureConstellationCrafter;
import thelm.packagedastral.structure.StructureMarkedRelay;
import thelm.packagedastral.structure.StructureTraitCrafter;
import thelm.packagedastral.tile.TileAttunementCrafter;
import thelm.packagedastral.tile.TileConstellationCrafter;
import thelm.packagedastral.tile.TileDiscoveryCrafter;
import thelm.packagedastral.tile.TileTraitCrafter;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class PackagedAstralPatchouliHandler {
    public static void init() {
        PatchouliAPI.instance.setConfigFlag("packagedastral:discovery", TileDiscoveryCrafter.enabled);
        PatchouliAPI.instance.setConfigFlag("packagedastral:attunement", TileAttunementCrafter.enabled);
        PatchouliAPI.instance.setConfigFlag("packagedastral:constellation", TileConstellationCrafter.enabled);
        PatchouliAPI.instance.setConfigFlag("packagedastral:trait", TileTraitCrafter.enabled);
        PackagedAstralPatchouliHandler.registerSimpleMultiblock(StructureAttunementCrafter.INSTANCE);
        PackagedAstralPatchouliHandler.registerSimpleMultiblock(StructureConstellationCrafter.INSTANCE);
        PackagedAstralPatchouliHandler.registerSimpleMultiblock(StructureTraitCrafter.INSTANCE);
        PackagedAstralPatchouliHandler.registerSimpleMultiblock(StructureMarkedRelay.INSTANCE);
    }

    public static void registerSimpleMultiblock(PatternBlockArray structure) {
        PatchouliAPI.instance.registerMultiblock(structure.getRegistryName(), PackagedAstralPatchouliHandler.convertSimpleMultiblock((BlockArray)structure));
    }

    public static IMultiblock convertSimpleMultiblock(BlockArray structure) {
        Vec3i min = structure.getMin();
        Vec3i max = structure.getMax();
        Vec3i size = structure.getSize();
        Map patternMap = structure.getPattern();
        Object2CharLinkedOpenHashMap targetMap = new Object2CharLinkedOpenHashMap();
        char nextChar = 'a';
        String[][] pattern = new String[size.func_177956_o()][size.func_177958_n()];
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        for (int y = max.func_177956_o(); y >= min.func_177956_o(); --y) {
            for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
                StringBuilder sb = new StringBuilder();
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    currentPos.func_181079_c(x, y, z);
                    if (patternMap.containsKey(currentPos)) {
                        IBlockState state = ((BlockArray.BlockInformation)patternMap.get((Object)currentPos)).state;
                        if (!targetMap.containsKey((Object)state)) {
                            char c;
                            if (x == 0 && y == 0 && z == 0) {
                                c = '0';
                            } else {
                                c = nextChar;
                                nextChar = (char)(nextChar + 1);
                            }
                            targetMap.put((Object)state, c);
                        }
                        sb.append(targetMap.getChar((Object)state));
                        continue;
                    }
                    if (x == 0 && y == 0 && z == 0) {
                        targetMap.put((Object)PatchouliAPI.instance.anyMatcher(), '0');
                        sb.append('0');
                        continue;
                    }
                    sb.append('_');
                }
                pattern[max.func_177956_o() - y][x - min.func_177958_n()] = sb.toString();
            }
        }
        Object[] targets = targetMap.object2CharEntrySet().stream().flatMap(entry -> Stream.of(Character.valueOf(entry.getCharValue()), entry.getKey())).toArray();
        return PatchouliAPI.instance.makeMultiblock(pattern, targets);
    }
}

