/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.integration.patchouli.component;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.AltarRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.DiscoveryRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.VariableHolder;
import vazkii.patchouli.client.book.gui.GuiBook;

public class ComponentAltarRecipeGrid
implements ICustomComponent {
    public static final ResourceLocation DISCOVERY_GRID = new ResourceLocation("packagedastral:textures/gui/patchouli/discovery_grid.png");
    public static final ResourceLocation ATTUNEMENT_GRID = new ResourceLocation("packagedastral:textures/gui/patchouli/attunement_grid.png");
    public static final ResourceLocation CONSTELLATION_GRID = new ResourceLocation("packagedastral:textures/gui/patchouli/constellation_grid.png");
    public static final ResourceLocation TRAIT_GRID = new ResourceLocation("packagedastral:textures/gui/patchouli/trait_grid.png");
    public static final RenderConstellation.BrightnessFunction BRIGHTNESS_FUNCTION = new RenderConstellation.BrightnessFunction(){

        public float getBrightness() {
            return 0.5f;
        }
    };
    @VariableHolder
    @SerializedName(value="recipe")
    public String recipeRaw;
    transient AbstractAltarRecipe altarRecipe;
    transient int x;
    transient int y;

    public void build(int componentX, int componentY, int pageNum) {
        this.altarRecipe = AltarRecipeRegistry.getRecipeSlow((ResourceLocation)new ResourceLocation("astralsorcery", "shaped/" + this.recipeRaw));
        if (this.altarRecipe == null) {
            this.altarRecipe = AltarRecipeRegistry.getRecipeSlow((ResourceLocation)new ResourceLocation("astralsorcery", "shaped/internal/altar/" + this.recipeRaw));
        }
        this.x = componentX < 0 ? 9 : componentX;
        this.y = componentY < 0 ? 12 : componentY;
    }

    public void render(IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        if (this.altarRecipe != null) {
            ItemHandle handle;
            TraitRecipe recipe;
            Minecraft mc = Minecraft.func_71410_x();
            GlStateManager.func_179147_l();
            switch (this.altarRecipe.getNeededLevel()) {
                case DISCOVERY: {
                    mc.field_71446_o.func_110577_a(DISCOVERY_GRID);
                    break;
                }
                case ATTUNEMENT: {
                    mc.field_71446_o.func_110577_a(ATTUNEMENT_GRID);
                    break;
                }
                case CONSTELLATION_CRAFT: {
                    mc.field_71446_o.func_110577_a(CONSTELLATION_GRID);
                    break;
                }
                case TRAIT_CRAFT: 
                case BRILLIANCE: {
                    mc.field_71446_o.func_110577_a(TRAIT_GRID);
                }
            }
            Gui.func_146110_a((int)(this.x - 1), (int)(this.y - 1), (float)1.0f, (float)1.0f, (int)100, (int)119, (float)128.0f, (float)128.0f);
            if (this.altarRecipe instanceof TraitRecipe) {
                recipe = (TraitRecipe)this.altarRecipe;
                IConstellation constellation = recipe.getRequiredConstellation();
                if (constellation != null) {
                    RenderConstellation.renderConstellationIntoGUI((Color)Color.BLACK, (IConstellation)constellation, (int)this.x, (int)this.y, (float)0.0f, (int)98, (int)98, (double)2.0, (RenderConstellation.BrightnessFunction)BRIGHTNESS_FUNCTION, (boolean)true, (boolean)false);
                }
                List ingredients = Lists.transform((List)recipe.getTraitItemHandles(), ItemHandle::getRecipeIngredient);
                float degreePerInput = 360.0f / (float)ingredients.size();
                int ticksElapsed = ((GuiBook)context.getGui()).ticksInBook;
                float currentDegree = (GuiScreen.func_146272_n() ? (float)ticksElapsed : (float)ticksElapsed + partialTicks) - 90.0f;
                for (Ingredient ingredient : ingredients) {
                    double radians = Math.toRadians(currentDegree);
                    double xPos = (double)(this.x + 3 + 38) + Math.cos(radians) * 48.0;
                    double yPos = (double)(this.y + 3 + 38) + Math.sin(radians) * 48.0;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)(xPos - (double)MathHelper.func_76128_c((double)xPos)), (double)(yPos - (double)MathHelper.func_76128_c((double)yPos)), (double)0.0);
                    context.renderIngredient(MathHelper.func_76128_c((double)xPos), MathHelper.func_76128_c((double)yPos), mouseX, mouseY, ingredient);
                    GlStateManager.func_179121_F();
                    currentDegree += degreePerInput;
                }
                ItemHandle handle2 = recipe.getInnerTraitItemHandle(TraitRecipe.TraitRecipeSlot.UPPER_CENTER);
                if (handle2 != null) {
                    context.renderIngredient(this.x + 3 + 38, this.y + 3 + 0, mouseX, mouseY, handle2.getRecipeIngredient());
                }
                if ((handle2 = recipe.getInnerTraitItemHandle(TraitRecipe.TraitRecipeSlot.LEFT_CENTER)) != null) {
                    context.renderIngredient(this.x + 3 + 0, this.y + 3 + 38, mouseX, mouseY, handle2.getRecipeIngredient());
                }
                if ((handle2 = recipe.getInnerTraitItemHandle(TraitRecipe.TraitRecipeSlot.RIGHT_CENTER)) != null) {
                    context.renderIngredient(this.x + 3 + 76, this.y + 3 + 38, mouseX, mouseY, handle2.getRecipeIngredient());
                }
                if ((handle2 = recipe.getInnerTraitItemHandle(TraitRecipe.TraitRecipeSlot.LOWER_CENTER)) != null) {
                    context.renderIngredient(this.x + 3 + 38, this.y + 3 + 76, mouseX, mouseY, handle2.getRecipeIngredient());
                }
            }
            if (this.altarRecipe instanceof ConstellationRecipe) {
                recipe = (ConstellationRecipe)this.altarRecipe;
                handle = recipe.getCstItemHandle(ConstellationRecipe.ConstellationAtlarSlot.UP_UP_LEFT);
                if (handle != null) {
                    context.renderIngredient(this.x + 3 + 19, this.y + 3 + 0, mouseX, mouseY, handle.getRecipeIngredient());
                }
                if ((handle = recipe.getCstItemHandle(ConstellationRecipe.ConstellationAtlarSlot.UP_UP_RIGHT)) != null) {
                    context.renderIngredient(this.x + 3 + 57, this.y + 3 + 0, mouseX, mouseY, handle.getRecipeIngredient());
                }
                if ((handle = recipe.getCstItemHandle(ConstellationRecipe.ConstellationAtlarSlot.UP_LEFT_LEFT)) != null) {
                    context.renderIngredient(this.x + 3 + 0, this.y + 3 + 19, mouseX, mouseY, handle.getRecipeIngredient());
                }
                if ((handle = recipe.getCstItemHandle(ConstellationRecipe.ConstellationAtlarSlot.UP_RIGHT_RIGHT)) != null) {
                    context.renderIngredient(this.x + 3 + 76, this.y + 3 + 19, mouseX, mouseY, handle.getRecipeIngredient());
                }
                if ((handle = recipe.getCstItemHandle(ConstellationRecipe.ConstellationAtlarSlot.DOWN_LEFT_LEFT)) != null) {
                    context.renderIngredient(this.x + 3 + 0, this.y + 3 + 57, mouseX, mouseY, handle.getRecipeIngredient());
                }
                if ((handle = recipe.getCstItemHandle(ConstellationRecipe.ConstellationAtlarSlot.DOWN_RIGHT_RIGHT)) != null) {
                    context.renderIngredient(this.x + 3 + 76, this.y + 3 + 57, mouseX, mouseY, handle.getRecipeIngredient());
                }
                if ((handle = recipe.getCstItemHandle(ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_LEFT)) != null) {
                    context.renderIngredient(this.x + 3 + 19, this.y + 3 + 76, mouseX, mouseY, handle.getRecipeIngredient());
                }
                if ((handle = recipe.getCstItemHandle(ConstellationRecipe.ConstellationAtlarSlot.DOWN_DOWN_RIGHT)) != null) {
                    context.renderIngredient(this.x + 3 + 57, this.y + 3 + 76, mouseX, mouseY, handle.getRecipeIngredient());
                }
            }
            if (this.altarRecipe instanceof AttunementRecipe) {
                recipe = (AttunementRecipe)this.altarRecipe;
                handle = recipe.getAttItemHandle(AttunementRecipe.AttunementAltarSlot.UPPER_LEFT);
                if (handle != null) {
                    context.renderIngredient(this.x + 3 + 0, this.y + 3 + 0, mouseX, mouseY, handle.getRecipeIngredient());
                }
                if ((handle = recipe.getAttItemHandle(AttunementRecipe.AttunementAltarSlot.UPPER_RIGHT)) != null) {
                    context.renderIngredient(this.x + 3 + 76, this.y + 3 + 0, mouseX, mouseY, handle.getRecipeIngredient());
                }
                if ((handle = recipe.getAttItemHandle(AttunementRecipe.AttunementAltarSlot.LOWER_LEFT)) != null) {
                    context.renderIngredient(this.x + 3 + 0, this.y + 3 + 76, mouseX, mouseY, handle.getRecipeIngredient());
                }
                if ((handle = recipe.getAttItemHandle(AttunementRecipe.AttunementAltarSlot.LOWER_RIGHT)) != null) {
                    context.renderIngredient(this.x + 3 + 76, this.y + 3 + 76, mouseX, mouseY, handle.getRecipeIngredient());
                }
            }
            if (this.altarRecipe instanceof DiscoveryRecipe) {
                recipe = (DiscoveryRecipe)this.altarRecipe;
                for (ShapedRecipeSlot srs : ShapedRecipeSlot.values()) {
                    handle = recipe.getNativeRecipe().getExpectedStackHandle(srs);
                    if (handle == null) continue;
                    int i = srs.ordinal();
                    context.renderIngredient(this.x + 3 + (1 + i % 3) * 19, this.y + 3 + (1 + i / 3) * 19, mouseX, mouseY, handle.getRecipeIngredient());
                }
            }
        }
    }
}

