/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.recipe;

import hellfirepvp.astralsorcery.common.crafting.IAltarUpgradeRecipe;
import hellfirepvp.astralsorcery.common.crafting.INighttimeRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.AltarRecipeRegistry;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thelm.packagedastral.recipe.IRecipeInfoAltar;
import thelm.packagedastral.recipe.RecipeTypeAttunement;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.util.PatternHelper;

public class RecipeInfoAttunement
implements IRecipeInfoAltar {
    AbstractAltarRecipe recipe;
    List<ItemStack> input = new ArrayList<ItemStack>();
    List<ItemStack> matrix = NonNullList.func_191197_a((int)13, (Object)ItemStack.field_190927_a);
    ItemStack output = ItemStack.field_190927_a;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public void readFromNBT(NBTTagCompound nbt) {
        this.input.clear();
        this.patterns.clear();
        this.recipe = AltarRecipeRegistry.getRecipeSlow((ResourceLocation)new ResourceLocation(nbt.func_74779_i("Recipe")));
        MiscUtil.loadAllItems((NBTTagList)nbt.func_150295_c("Matrix", 10), this.matrix);
        this.output = new ItemStack(nbt.func_74775_l("Output"));
        this.input.addAll(MiscUtil.condenseStacks(this.matrix));
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PatternHelper((IRecipeInfo)this, i));
            ++i;
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.recipe != null) {
            nbt.func_74778_a("Recipe", this.recipe.getNativeRecipe().getRegistryName().toString());
        }
        NBTTagList matrixTag = MiscUtil.saveAllItems((NBTTagList)new NBTTagList(), this.matrix);
        nbt.func_74782_a("Matrix", (NBTBase)matrixTag);
        nbt.func_74782_a("Output", (NBTBase)this.output.func_77955_b(new NBTTagCompound()));
        return nbt;
    }

    public IRecipeType getRecipeType() {
        return RecipeTypeAttunement.INSTANCE;
    }

    @Override
    public int getLevel() {
        return 1;
    }

    public boolean isValid() {
        return this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public AbstractAltarRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public List<ItemStack> getMatrix() {
        return Collections.unmodifiableList(this.matrix);
    }

    @Override
    public List<ItemStack> getRelayInputs() {
        return Collections.emptyList();
    }

    @Override
    public boolean requiresNight() {
        return this.recipe instanceof INighttimeRecipe;
    }

    @Override
    public int getLevelRequired() {
        return this.recipe.getNeededLevel().ordinal();
    }

    @Override
    public int getTimeRequired() {
        return this.recipe.craftingTickTime();
    }

    @Override
    public int getStarlightRequired() {
        return this.recipe.getPassiveStarlightRequired();
    }

    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        this.recipe = null;
        this.input.clear();
        this.patterns.clear();
        TileAltar fakeAltar = new TileAltar(TileAltar.AltarLevel.ATTUNEMENT);
        TileReceiverBaseInventory.ItemHandlerTile handler = fakeAltar.getInventoryHandler();
        int[] slotArray = RecipeTypeAttunement.SLOTS.toIntArray();
        for (int i = 0; i < 13; ++i) {
            ItemStack toSet = input.get(slotArray[i]);
            toSet.func_190920_e(1);
            this.matrix.set(i, toSet.func_77946_l());
            try {
                handler.setStackInSlot(i, toSet.func_77946_l());
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        fakeAltar.func_145834_a(world);
        long prevTime = world.func_72820_D();
        world.func_72877_b(18000L);
        for (int i = 1; i >= 0; --i) {
            TileAltar.AltarLevel level = TileAltar.AltarLevel.values()[i];
            for (AbstractAltarRecipe recipe : AltarRecipeRegistry.getRecipesForLevel((TileAltar.AltarLevel)level)) {
                if (recipe instanceof IAltarUpgradeRecipe || !recipe.matches(fakeAltar, handler, true)) continue;
                try {
                    this.output = recipe.getOutput(fakeAltar.copyGetCurrentCraftingGrid(), fakeAltar).func_77946_l();
                }
                catch (Exception e) {
                    continue;
                }
                this.recipe = recipe;
                this.input.addAll(MiscUtil.condenseStacks(this.matrix));
                int j = 0;
                while (j * 9 < this.input.size()) {
                    this.patterns.add((IPackagePattern)new PatternHelper((IRecipeInfo)this, j));
                    ++j;
                }
                world.func_72877_b(prevTime);
                return;
            }
        }
        world.func_72877_b(prevTime);
        this.matrix.clear();
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = RecipeTypeAttunement.SLOTS.toIntArray();
        for (int i = 0; i < 13; ++i) {
            map.put(slotArray[i], (Object)this.matrix.get(i));
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecipeInfoAttunement) {
            RecipeInfoAttunement other = (RecipeInfoAttunement)obj;
            return MiscUtil.recipeEquals((IRecipeInfo)this, (Object)this.recipe, (IRecipeInfo)other, (Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return MiscUtil.recipeHashCode((IRecipeInfo)this, (Object)this.recipe);
    }
}

