/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.recipe;

import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalPropertyItem;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedastral.recipe.RecipeInfoDiscovery;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;

public class RecipeTypeDiscovery
implements IRecipeType {
    public static final RecipeTypeDiscovery INSTANCE = new RecipeTypeDiscovery();
    public static final ResourceLocation NAME = new ResourceLocation("packagedastral:discovery");
    public static final IntSet SLOTS;
    public static final List<String> CATEGORIES;
    public static final Color COLOR;
    public static final Color COLOR_DISABLED;

    protected RecipeTypeDiscovery() {
    }

    public ResourceLocation getName() {
        return NAME;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)"recipe.packagedastral.discovery");
    }

    public String getLocalizedNameShort() {
        return I18n.func_74838_a((String)"recipe.packagedastral.discovery.short");
    }

    public IRecipeInfo getNewRecipeInfo() {
        return new RecipeInfoDiscovery();
    }

    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    public List<String> getJEICategories() {
        return CATEGORIES;
    }

    @Optional.Method(modid="jei")
    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeLayout recipeLayout, String category) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
        int index = 0;
        int[] slotArray = SLOTS.toIntArray();
        for (Map.Entry entry : ingredients.entrySet()) {
            IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
            if (ingredient.isInput()) {
                ItemStack displayed = (ItemStack)((IGuiIngredient)entry.getValue()).getDisplayedIngredient();
                if (displayed != null && !displayed.func_190926_b()) {
                    if (displayed.func_77973_b() instanceof CrystalPropertyItem) {
                        displayed = displayed.func_77946_l();
                        CrystalPropertyItem crystal = (CrystalPropertyItem)displayed.func_77973_b();
                        CrystalProperties properties = new CrystalProperties(crystal.getMaxSize(displayed), 100, 100, 0, -1);
                        CrystalProperties.applyCrystalProperties((ItemStack)displayed, (CrystalProperties)properties);
                    }
                    map.put(slotArray[index], (Object)displayed);
                }
                ++index;
            }
            if (index < 9) continue;
            break;
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public Object getRepresentation() {
        return new ItemStack((Block)BlocksAS.blockAltar, 1, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public Color getSlotColor(int slot) {
        if (!SLOTS.contains(slot) && slot != 85) {
            return COLOR_DISABLED;
        }
        return COLOR;
    }

    static {
        CATEGORIES = Collections.singletonList("astralsorcery.altar.discovery");
        COLOR = new Color(139, 139, 139);
        COLOR_DISABLED = new Color(64, 64, 64);
        SLOTS = new IntLinkedOpenHashSet();
        for (int i = 3; i < 6; ++i) {
            for (int j = 3; j < 6; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
    }
}

