/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.recipe;

import com.google.common.collect.ImmutableList;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalPropertyItem;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedastral.recipe.RecipeInfoTrait;
import thelm.packagedastral.recipe.RecipeTypeConstellation;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;

public class RecipeTypeTrait
implements IRecipeType {
    public static final RecipeTypeTrait INSTANCE;
    public static final ResourceLocation NAME;
    public static final IntSet SLOTS;
    public static final IntSet SLOTS_CENTER;
    public static final List<String> CATEGORIES;
    public static final Color COLOR;
    public static final Color COLOR_RELAY;
    public static final Color COLOR_DISABLED;

    protected RecipeTypeTrait() {
    }

    public ResourceLocation getName() {
        return NAME;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)"recipe.packagedastral.trait");
    }

    public String getLocalizedNameShort() {
        return I18n.func_74838_a((String)"recipe.packagedastral.trait.short");
    }

    public IRecipeInfo getNewRecipeInfo() {
        return new RecipeInfoTrait();
    }

    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    public List<String> getJEICategories() {
        return CATEGORIES;
    }

    @Optional.Method(modid="jei")
    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeLayout recipeLayout, String category) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
        int index = 0;
        int[] slotArray = SLOTS.toIntArray();
        for (Map.Entry entry : ingredients.entrySet()) {
            IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
            if (ingredient.isInput()) {
                ItemStack displayed = (ItemStack)((IGuiIngredient)entry.getValue()).getDisplayedIngredient();
                if (displayed != null && !displayed.func_190926_b()) {
                    if (displayed.func_77973_b() instanceof CrystalPropertyItem) {
                        displayed = displayed.func_77946_l();
                        CrystalPropertyItem crystal = (CrystalPropertyItem)displayed.func_77973_b();
                        CrystalProperties properties = new CrystalProperties(crystal.getMaxSize(displayed), 100, 100, 0, -1);
                        CrystalProperties.applyCrystalProperties((ItemStack)displayed, (CrystalProperties)properties);
                    }
                    map.put(slotArray[index], (Object)displayed);
                }
                ++index;
            }
            if (index < 73) continue;
            break;
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public Object getRepresentation() {
        return new ItemStack((Block)BlocksAS.blockAltar, 1, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public Color getSlotColor(int slot) {
        if (!SLOTS.contains(slot) && slot != 85) {
            return COLOR_DISABLED;
        }
        if (!SLOTS_CENTER.contains(slot) && slot != 85) {
            return COLOR_RELAY;
        }
        return COLOR;
    }

    static {
        int j;
        int i;
        INSTANCE = new RecipeTypeTrait();
        NAME = new ResourceLocation("packagedastral:trait");
        CATEGORIES = ImmutableList.of((Object)"astralsorcery.altar.trait", (Object)"astralsorcery.altar.constellation", (Object)"astralsorcery.altar.attunement", (Object)"astralsorcery.altar.discovery");
        COLOR = new Color(139, 139, 139);
        COLOR_RELAY = new Color(179, 179, 139);
        COLOR_DISABLED = new Color(64, 64, 64);
        SLOTS = new IntLinkedOpenHashSet((IntCollection)RecipeTypeConstellation.SLOTS);
        SLOTS.add(22);
        SLOTS.add(38);
        SLOTS.add(42);
        SLOTS.add(58);
        SLOTS_CENTER = new IntLinkedOpenHashSet((IntCollection)SLOTS);
        for (i = 0; i < 2; ++i) {
            for (j = 1; j < 8; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
        for (i = 2; i < 7; ++i) {
            SLOTS.add(9 * i);
            SLOTS.add(9 * i + 1);
            SLOTS.add(9 * i + 7);
            SLOTS.add(9 * i + 8);
        }
        for (i = 7; i < 9; ++i) {
            for (j = 1; j < 8; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
    }
}

