/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.tile;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import hellfirepvp.astralsorcery.client.util.PositionedLoopSound;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.AltarRecipeRegistry;
import hellfirepvp.astralsorcery.common.entities.EntityFlare;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.starlight.IStarlightTransmission;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightUpdateHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SkyCollectionHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedastral.client.gui.GuiDiscoveryCrafter;
import thelm.packagedastral.container.ContainerDiscoveryCrafter;
import thelm.packagedastral.integration.appeng.networking.HostHelperTileDiscoveryCrafter;
import thelm.packagedastral.inventory.InventoryDiscoveryCrafter;
import thelm.packagedastral.recipe.IRecipeInfoAltar;
import thelm.packagedastral.tile.IAltarCrafter;
import thelm.packagedastral.tile.TileMarkedRelay;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TileUnpackager;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2")})
public class TileDiscoveryCrafter
extends TileBase
implements ITickable,
IPackageCraftingMachine,
IAltarCrafter,
IGridHost,
IActionHost {
    public static final Random RANDOM = new Random();
    public static boolean enabled = true;
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static int starlightCapacity = 1000;
    public static boolean craftingEffects = true;
    public static boolean requiresNight = true;
    public static boolean drawMEEnergy = true;
    public boolean firstTick = true;
    public boolean doesSeeSky = false;
    public float posDistribution = -1.0f;
    public TileAltar fakeAltar = new TileAltar(TileAltar.AltarLevel.DISCOVERY);
    public AbstractAltarRecipe effectRecipe = null;
    public Object clientCraftSound = null;
    public int starlight = 0;
    public boolean isWorking = false;
    public int progress = 0;
    public int progressReq = 0;
    public int remainingProgress = 0;
    public int starlightReq = 0;
    public IRecipeInfoAltar currentRecipe;
    public HostHelperTileDiscoveryCrafter hostHelper;

    public TileDiscoveryCrafter() {
        this.setInventory(new InventoryDiscoveryCrafter(this));
        this.setEnergyStorage(new EnergyStorage((TileBase)this, energyCapacity));
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTileDiscoveryCrafter(this);
        }
    }

    public String getUnLocalizedDisplayName() {
        return "tile.packagedastral.discovery_crafter.name";
    }

    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedastral.discovery_crafter.name");
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.fakeAltar.func_145834_a(world);
    }

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        this.fakeAltar.func_174878_a(pos);
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K) {
                WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler((World)this.field_145850_b);
                handler.addTransmissionTile((IStarlightTransmission)this);
                IPrismTransmissionNode node = handler.getTransmissionNode(this.field_174879_c);
                if (node != null && node.needsUpdate()) {
                    StarlightUpdateHandler.getInstance().addNode(this.field_145850_b, node);
                }
                TileMarkedRelay.updateNearbyAltarPos(this.field_145850_b, this.field_174879_c);
            }
        }
        if (this.field_145850_b.func_82737_E() % 16L == 0L) {
            this.doesSeeSky = MiscUtils.canSeeSky((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), (boolean)true, (boolean)this.doesSeeSky);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0) {
                    this.finishProcess();
                    if (this.hostHelper != null && this.hostHelper.isActive()) {
                        this.hostHelper.ejectItem();
                    } else {
                        this.ejectItems();
                    }
                }
            }
            this.starlightPassive();
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % 8L == 0L) {
                if (this.hostHelper != null && this.hostHelper.isActive()) {
                    this.hostHelper.ejectItem();
                    if (drawMEEnergy) {
                        this.hostHelper.chargeEnergy();
                    }
                } else {
                    this.ejectItems();
                }
            }
        } else {
            this.clientTick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void clientTick() {
        if (this.isWorking) {
            if (craftingEffects && this.effectRecipe != null) {
                try {
                    this.effectRecipe.onCraftClientTick(this.fakeAltar, ActiveCraftingTask.CraftingState.ACTIVE, this.field_145850_b.func_82737_E(), RANDOM);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.BLOCKS) > 0.0f) {
                if (this.clientCraftSound == null || ((PositionedLoopSound)this.clientCraftSound).hasStoppedPlaying()) {
                    PositionedLoopSound posSound = new PositionedLoopSound((SoundEvent)Sounds.attunement, SoundCategory.BLOCKS, 0.25f, 1.0f, new Vector3(this.field_174879_c));
                    posSound.setRefreshFunction(() -> this.func_145837_r() || Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER) <= 0.0f || !this.isWorking);
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)posSound);
                    this.clientCraftSound = posSound;
                }
            } else {
                this.clientCraftSound = null;
            }
        }
    }

    public boolean acceptPackage(IRecipeInfo recipeInfo, List<ItemStack> stacks, EnumFacing facing) {
        IRecipeInfoAltar recipe;
        if (!this.isBusy() && recipeInfo.isValid() && recipeInfo instanceof IRecipeInfoAltar && (recipe = (IRecipeInfoAltar)recipeInfo).getLevel() == 0 && (!requiresNight || !recipe.requiresNight() || ConstellationSkyHandler.getInstance().isNight(this.field_145850_b))) {
            ItemStack slotStack = this.inventory.func_70301_a(9);
            ItemStack outputStack = recipe.getOutput();
            if (slotStack.func_190926_b() || slotStack.func_77973_b() == outputStack.func_77973_b() && slotStack.func_77952_i() == outputStack.func_77952_i() && ItemStack.areItemStackShareTagsEqual((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.func_190916_E() + outputStack.func_190916_E() <= outputStack.func_77976_d()) {
                this.currentRecipe = recipe;
                this.effectRecipe = recipe.getRecipe();
                this.isWorking = true;
                this.progressReq = recipe.getTimeRequired() / (int)Math.round(2.0 * Math.pow(2.0, Math.max(0, 0 - recipe.getLevelRequired())));
                this.remainingProgress = energyReq;
                this.starlightReq = recipe.getStarlightRequired();
                for (int i = 0; i < 9; ++i) {
                    this.inventory.func_70299_a(i, recipe.getMatrix().get(i).func_77946_l());
                }
                this.syncTile(false);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.inventory.stacks.subList(0, 9).stream().allMatch(ItemStack::func_190926_b);
    }

    protected void tickProcess() {
        if (this.starlight >= this.currentRecipe.getStarlightRequired()) {
            ++this.progress;
            if (this.progress >= this.progressReq) {
                this.progress = this.progressReq;
                int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
                this.remainingProgress -= energy;
            }
        }
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        this.starlight -= this.starlightReq;
        if (this.inventory.func_70301_a(9).func_190926_b()) {
            this.inventory.func_70299_a(9, this.currentRecipe.getOutput());
        } else {
            this.inventory.func_70301_a(9).func_190917_f(this.currentRecipe.getOutput().func_190916_E());
        }
        for (int i = 0; i < 9; ++i) {
            this.inventory.func_70299_a(i, MiscUtil.getContainerItem((ItemStack)this.inventory.func_70301_a(i)));
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)Sounds.craftFinish, SoundCategory.BLOCKS, 1.0f, 1.7f);
        EntityFlare.spawnAmbient((World)this.field_145850_b, (Vector3)new Vector3(this.field_174879_c).add((double)(-3.0f + RANDOM.nextFloat() * 7.0f), 0.6, (double)(-3.0f + RANDOM.nextFloat() * 7.0f)));
        this.endProcess();
    }

    public void endProcess() {
        this.progressReq = 0;
        this.progress = 0;
        this.remainingProgress = 0;
        this.starlightReq = 0;
        this.isWorking = false;
        this.effectRecipe = null;
        this.currentRecipe = null;
        this.syncTile(false);
        this.func_70296_d();
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 9 : 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tile == null || tile instanceof TileUnpackager || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            for (int i = 9; i >= endIndex; --i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.inventory.func_70299_a(i, stackRem);
            }
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.inventory.func_70301_a(10);
        if (energyStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.inventory.func_70299_a(10, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void receiveStarlight(IWeakConstellation type, double amount) {
        if (amount <= 0.001) {
            return;
        }
        this.starlight = Math.min(starlightCapacity, (int)((double)this.starlight + amount * 200.0));
        this.func_70296_d();
    }

    protected void starlightPassive() {
        int yLevel;
        boolean update = this.starlight > 0;
        this.starlight = (int)((double)this.starlight * 0.95);
        if (this.doesSeeSky && ConstellationSkyHandler.getInstance().getWorldHandler(this.field_145850_b) != null && (yLevel = this.field_174879_c.func_177956_o()) > 40) {
            float collect = 160.0f;
            float dstr = yLevel > 120 ? 1.0f + (float)(yLevel - 120) / 272.0f : (float)(yLevel - 20) / 100.0f;
            if (this.posDistribution == -1.0f) {
                this.posDistribution = SkyCollectionHelper.getSkyNoiseDistribution((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
            collect *= dstr;
            collect = (float)((double)collect * (0.6 + 0.4 * (double)this.posDistribution));
            collect = (float)((double)collect * (0.2 + 0.8 * (double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.field_145850_b)));
            this.starlight = Math.min(starlightCapacity, (int)((float)this.starlight + collect));
            update = true;
        }
        if (update) {
            this.func_70296_d();
        }
    }

    public void onBreak() {
        if (!this.field_145850_b.field_72995_K) {
            WorldNetworkHandler handler = WorldNetworkHandler.getNetworkHandler((World)this.field_145850_b);
            IPrismTransmissionNode node = handler.getTransmissionNode(this.field_174879_c);
            if (node != null) {
                StarlightUpdateHandler.getInstance().removeNode(this.field_145850_b, node);
            }
            handler.removeTransmission((IStarlightTransmission)this);
        }
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.inventory.stacks.subList(0, 10).stream().allMatch(ItemStack::func_190926_b)) {
            return 15;
        }
        return 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        NBTTagCompound tag;
        IRecipeInfo recipe;
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
        super.func_145839_a(nbt);
        this.starlight = nbt.func_74762_e("Starlight");
        this.progressReq = nbt.func_74762_e("ProgressReq");
        this.progress = nbt.func_74762_e("Progress");
        this.remainingProgress = nbt.func_74762_e("EnergyProgress");
        this.starlightReq = nbt.func_74762_e("StarlightReq");
        this.currentRecipe = null;
        if (nbt.func_74764_b("Recipe") && (recipe = MiscUtil.readRecipeFromNBT((NBTTagCompound)(tag = nbt.func_74775_l("Recipe")))) instanceof IRecipeInfoAltar && ((IRecipeInfoAltar)recipe).getLevel() == 0) {
            this.currentRecipe = (IRecipeInfoAltar)recipe;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Starlight", this.starlight);
        nbt.func_74768_a("ProgressReq", this.progressReq);
        nbt.func_74768_a("Progress", this.progress);
        nbt.func_74768_a("EnergyProgress", this.remainingProgress);
        nbt.func_74768_a("StarlightReq", this.starlightReq);
        if (this.currentRecipe != null) {
            NBTTagCompound tag = MiscUtil.writeRecipeToNBT((NBTTagCompound)new NBTTagCompound(), (IRecipeInfo)this.currentRecipe);
            nbt.func_74782_a("Recipe", (NBTBase)tag);
        }
        if (this.hostHelper != null) {
            this.hostHelper.writeToNBT(nbt);
        }
        return nbt;
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.isWorking = nbt.func_74767_n("Working");
        this.effectRecipe = null;
        if (nbt.func_74764_b("EffectRecipe")) {
            this.effectRecipe = AltarRecipeRegistry.getRecipe((int)nbt.func_74762_e("EffectRecipe"));
        }
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        nbt.func_74757_a("Working", this.isWorking);
        if (this.effectRecipe != null) {
            nbt.func_74768_a("EffectRecipe", this.effectRecipe.getUniqueRecipeId());
        }
        return nbt;
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored();
    }

    public int getScaledStarlight(int scale) {
        if (starlightCapacity <= 0) {
            return 0;
        }
        return scale * this.starlight / starlightCapacity;
    }

    public int getScaledStarlightReq(int scale) {
        if (starlightCapacity <= 0 || this.starlight >= this.starlightReq) {
            return 0;
        }
        return scale * this.starlightReq / starlightCapacity - this.getScaledStarlight(scale);
    }

    public int getScaledProgress(int scale) {
        if (this.progress <= 0 || this.progressReq <= 0) {
            return 0;
        }
        return scale * this.progress / this.progressReq;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiDiscoveryCrafter(new ContainerDiscoveryCrafter(player.field_71071_by, this));
    }

    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerDiscoveryCrafter(player.field_71071_by, this);
    }
}

