/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedastral.tile;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.google.common.collect.Streams;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.structure.change.ChangeSubscriber;
import hellfirepvp.astralsorcery.common.structure.match.StructureMatcherPatternArray;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.PatternMatchHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.log.LogCategory;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedastral.integration.appeng.networking.HostHelperTileMarkedRelay;
import thelm.packagedastral.inventory.InventoryMarkedRelay;
import thelm.packagedastral.structure.StructureMarkedRelay;
import thelm.packagedastral.tile.IAltarCrafter;
import thelm.packagedauto.tile.TileBase;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2")})
public class TileMarkedRelay
extends TileBase
implements ITickable,
IGridHost,
IActionHost {
    public static final Random RANDOM = new Random();
    public boolean firstTick = true;
    public boolean doesSeeSky = false;
    public ChangeSubscriber<StructureMatcherPatternArray> structureMatch = null;
    public boolean structureValid = false;
    public BlockPos altarPos = null;
    public HostHelperTileMarkedRelay hostHelper;

    public TileMarkedRelay() {
        this.setInventory(new InventoryMarkedRelay(this));
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTileMarkedRelay(this);
        }
    }

    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedastral.marked_relay.name");
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K && this.hostHelper != null) {
                this.hostHelper.isActive();
            }
        }
        if (this.field_145850_b.func_82737_E() % 16L == 0L) {
            this.doesSeeSky = MiscUtils.canSeeSky((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177984_a(), (boolean)true, (boolean)this.doesSeeSky);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.matchStructure();
            if (this.altarPos != null && this.field_145850_b.func_175667_e(this.altarPos)) {
                TileEntity tile = this.field_145850_b.func_175625_s(this.altarPos);
                if (tile instanceof IAltarCrafter) {
                    this.provideStarlight((IAltarCrafter)tile);
                } else {
                    this.updateAltarPos();
                }
            }
        } else {
            this.clientTick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void clientTick() {
        if (this.structureValid) {
            Vector3 at;
            if (RANDOM.nextInt(3) == 0) {
                at = new Vector3(this.field_174879_c);
                at.add((double)RANDOM.nextFloat() * 2.6 - 0.8, 0.0, (double)RANDOM.nextFloat() * 2.6 - 0.8);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle((Vector3)at);
                p.setAlphaMultiplier(0.7f);
                p.setMaxAge((int)(30.0f + RANDOM.nextFloat() * 50.0f));
                p.gravity(0.01).scale(0.3f + RANDOM.nextFloat() * 0.1f);
                if (RANDOM.nextBoolean()) {
                    p.setColor(Color.WHITE);
                }
            }
            if (this.altarPos != null && this.doesSeeSky && RANDOM.nextInt(4) == 0) {
                at = new Vector3(this.field_174879_c);
                Vector3 dir = new Vector3(this.altarPos).subtract(at).normalize().multiply(0.05);
                at.add((double)RANDOM.nextFloat() * 0.4 + 0.3, (double)RANDOM.nextFloat() * 0.3 + 0.1, (double)RANDOM.nextFloat() * 0.4 + 0.3);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle((Vector3)at);
                p.setAlphaMultiplier(0.7f);
                p.motion(dir.getX(), dir.getY(), dir.getZ());
                p.setMaxAge((int)(15.0f + RANDOM.nextFloat() * 30.0f));
                p.gravity(0.015).scale(0.2f + RANDOM.nextFloat() * 0.04f);
                if (RANDOM.nextBoolean()) {
                    p.setColor(Color.WHITE);
                }
            }
        }
    }

    protected void provideStarlight(IAltarCrafter altar) {
        if (this.doesSeeSky) {
            WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler(this.field_145850_b);
            int yLevel = this.field_174879_c.func_177956_o();
            if (handle != null && yLevel > 40) {
                double coll = 0.3;
                float dstr = yLevel > 120 ? 1.0f : (float)(yLevel - 40) / 80.0f;
                coll *= (double)dstr;
                altar.receiveStarlight(null, coll *= 0.2 + 0.8 * (double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(this.field_145850_b));
            }
        }
    }

    protected void matchStructure() {
        boolean matches;
        StructureMarkedRelay structure = StructureMarkedRelay.INSTANCE;
        if (this.structureMatch == null) {
            this.structureMatch = PatternMatchHelper.getOrCreateMatcher((World)this.field_145850_b, (BlockPos)this.field_174879_c, (PatternBlockArray)structure);
        }
        boolean bl = matches = this.getInventory().func_70301_a(0).func_190926_b() && this.structureMatch.matches(this.field_145850_b);
        if (matches != this.structureValid) {
            LogCategory.STRUCTURE_MATCH.info(() -> "Structure match updated: " + ((Object)((Object)this)).getClass().getName() + " at " + this.field_174879_c + " (" + this.structureValid + " -> " + matches + ")");
            this.structureValid = matches;
            this.updateAltarPos();
            this.syncTile(false);
            this.func_70296_d();
        }
    }

    protected void updateAltarPos() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.altarPos = null;
        if (this.structureValid) {
            List<BlockPos> altars = TileMarkedRelay.getNearbyAltars(this.field_145850_b, this.field_174879_c);
            BlockPos nearestAltar = null;
            double nearestDist = Double.POSITIVE_INFINITY;
            for (BlockPos altar : altars) {
                double dist = altar.func_177951_i((Vec3i)this.field_174879_c);
                if (nearestAltar != null && !(dist < nearestDist)) continue;
                nearestAltar = altar;
                nearestDist = dist;
            }
            this.altarPos = nearestAltar;
        }
        this.syncTile(false);
        this.func_70296_d();
    }

    public static void updateNearbyAltarPos(World world, BlockPos pos) {
        TileMarkedRelay.getNearbyRelays(world, pos).forEach(TileMarkedRelay::updateAltarPos);
    }

    public static List<TileMarkedRelay> getNearbyRelays(World world, BlockPos pos) {
        return Streams.stream((Iterable)BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-16, -16, -16), (BlockPos)pos.func_177982_a(16, 16, 16))).map(checkPos -> {
            TileEntity tile;
            if (!checkPos.equals((Object)pos) && world.func_175667_e((BlockPos)checkPos) && (tile = world.func_175625_s((BlockPos)checkPos)) instanceof TileMarkedRelay) {
                return (TileMarkedRelay)tile;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<BlockPos> getNearbyAltars(World world, BlockPos pos) {
        return Streams.stream((Iterable)BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-16, -16, -16), (BlockPos)pos.func_177982_a(16, 16, 16))).map(checkPos -> {
            if (!checkPos.equals((Object)pos) && world.func_175667_e((BlockPos)checkPos) && world.func_175625_s((BlockPos)checkPos) instanceof IAltarCrafter) {
                return checkPos.func_185334_h();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void ejectItem() {
        if (this.hostHelper != null && this.hostHelper.isActive()) {
            this.hostHelper.ejectItem();
        }
        ItemStack stack = this.inventory.func_70301_a(0);
        this.inventory.func_70299_a(0, ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + dx, (double)this.field_174879_c.func_177956_o() + dy, (double)this.field_174879_c.func_177952_p() + dz, stack);
            entityitem.func_174869_p();
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
    }

    public int getComparatorSignal() {
        return this.inventory.func_70301_a(0).func_190926_b() ? 0 : 15;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.hostHelper != null) {
            this.hostHelper.writeToNBT(nbt);
        }
        return nbt;
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        super.readSyncNBT(nbt);
        this.inventory.readFromNBT(nbt);
        this.structureValid = nbt.func_74767_n("MultiblockValid");
        this.altarPos = null;
        if (nbt.func_74764_b("AltarPos")) {
            int[] posArray = nbt.func_74759_k("AltarPos");
            this.altarPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        }
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        super.writeSyncNBT(nbt);
        this.inventory.writeToNBT(nbt);
        nbt.func_74757_a("MultiblockValid", this.structureValid);
        if (this.altarPos != null) {
            nbt.func_74783_a("AltarPos", new int[]{this.altarPos.func_177958_n(), this.altarPos.func_177956_o(), this.altarPos.func_177952_p()});
        }
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return null;
    }

    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return null;
    }
}

