package thelm.packagedastral.block;

import hellfirepvp.observerlib.api.block.BlockStructureObserver;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.world.IBlockReader;
import thelm.packagedastral.PackagedAstral;
import thelm.packagedastral.tile.AttunementCrafterTile;
import thelm.packagedauto.block.BaseBlock;

public class AttunementCrafterBlock extends BaseBlock implements BlockStructureObserver {

	public static final AttunementCrafterBlock INSTANCE = new AttunementCrafterBlock();
	public static final Item ITEM_INSTANCE = new BlockItem(INSTANCE, new Item.Properties().tab(PackagedAstral.ITEM_GROUP)).setRegistryName("packagedastral:attunement_crafter");

	public AttunementCrafterBlock() {
		super(AbstractBlock.Properties.of(Material.STONE).strength(10F, 15F).noOcclusion().sound(SoundType.STONE));
		setRegistryName("packagedastral:attunement_crafter");
	}

	@Override
	public AttunementCrafterTile createTileEntity(BlockState state, IBlockReader world) {
		return AttunementCrafterTile.TYPE_INSTANCE.create();
	}
}
